/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.v2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexResults {
    private static final Logger logger = LoggerFactory.getLogger(IndexResults.class);
    private final Map<Object, IndexResults> children;
    private final Map<String, Object> values;
    private final Map<String, Collector<?, ?, ?>> coll;
    private final int depth;

    IndexResults(int depth) {
        this.depth = depth;
        this.values = new ConcurrentHashMap<String, Object>();
        this.coll = new ConcurrentHashMap();
        this.children = new ConcurrentHashMap<Object, IndexResults>();
    }

    public Map<String, Object> getValues() {
        return new HashMap<String, Object>(this.values);
    }

    public int getDepth() {
        return this.depth;
    }

    public Map<Object, IndexResults> getChildren() {
        return new HashMap<Object, IndexResults>(this.children);
    }

    void finish() {
        for (Map.Entry<String, Collector<?, ?, ?>> ee : this.coll.entrySet()) {
            Collector<?, ?, ?> collector = ee.getValue();
            Function<?, ?> finisher = collector.finisher();
            Object value = this.values.get(ee.getKey());
            Object newValue = finisher.apply(value);
            this.values.put(ee.getKey(), newValue);
        }
        this.children.values().forEach(IndexResults::finish);
    }

    void addRecursive(String valueName, Collector<Object, ?, ?> collector, List<Object> currentIndexes, List<Object> objects) {
        this.addRecursive(0, valueName, collector, currentIndexes, objects);
    }

    private void addRecursive(int indexIndex, String valueName, Collector<Object, ?, ?> collector, List<Object> currentIndexes, List<Object> objects) {
        logger.debug("Add recursive {} value {} indexes {} objects {}", new Object[]{indexIndex, valueName, currentIndexes, objects});
        Collector<Object, ?, ?> objectCollector = collector;
        Object handler = this.values.computeIfAbsent(valueName, key -> objectCollector.supplier().get());
        this.coll.put(valueName, objectCollector);
        BiConsumer<?, Object> accum = objectCollector.accumulator();
        objects.forEach(value -> accum.accept(handler, value));
        if (indexIndex == currentIndexes.size()) {
            return;
        }
        Object nextIndex = currentIndexes.get(indexIndex);
        this.children.computeIfAbsent(nextIndex, s -> new IndexResults(this.depth + 1));
        IndexResults next = this.children.get(nextIndex);
        next.addRecursive(indexIndex + 1, valueName, collector, currentIndexes, objects);
    }

    public String toMultiline() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            this.indent(str);
            str.append(entry.getKey());
            str.append(": ");
            str.append(entry.getValue());
            str.append(System.lineSeparator());
        }
        for (Map.Entry<Object, Object> entry : this.children.entrySet()) {
            this.indent(str);
            str.append(entry.getKey());
            str.append(System.lineSeparator());
            str.append(((IndexResults)entry.getValue()).toMultiline());
        }
        return str.toString();
    }

    private void indent(StringBuilder str) {
        for (int i = 0; i < this.depth; ++i) {
            str.append("  ");
        }
    }
}

