/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.statextract;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.zomis.fight.statextract.ClassExtractor;
import net.zomis.fight.statextract.IndexableResults;
import net.zomis.fight.statextract.InstancePoster;
import net.zomis.fight.statextract.Poster;
import net.zomis.fight.statextract.types.StatCollector;
import net.zomis.fight.statextract.types.StatCollectors;

public class Extractor {
    private final Object target;
    private final Map<Class<?>, ClassExtractor> classExtractorMap = new HashMap();
    private final List<InstancePoster> posters = Collections.synchronizedList(new ArrayList());

    private Extractor(Object target) {
        this.target = target;
    }

    public IndexableResults collectIndexable() {
        return new IndexableResults(this.posters);
    }

    public static Extractor extractor(Object target) {
        Extractor extractor = new Extractor(target);
        StatCollectors collectorTypes = new StatCollectors();
        for (Field field : target.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(target);
                Objects.requireNonNull(fieldValue, "Field cannot be null: " + field.getName());
                StatCollector statCollector = collectorTypes.get(field.getType());
                if (statCollector == null) continue;
                extractor.addExtractor(field.getName(), statCollector.postedType(field), statCollector, () -> statCollector.createCollector(fieldValue));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return extractor;
    }

    private void addExtractor(String name, Class<?> aClass, StatCollector statCollector, Supplier<Collector<?, ?, ?>> fieldValue) {
        this.extractFor(aClass).addCollector(name, statCollector, fieldValue);
    }

    private ClassExtractor extractFor(Class<?> aClass) {
        this.classExtractorMap.putIfAbsent(aClass, new ClassExtractor());
        return this.classExtractorMap.get(aClass);
    }

    public <T> void addPreHandler(Class<T> clazz, BiConsumer<Poster, ? super T> preHandler) {
        this.extractFor(clazz).addPreHandler(preHandler);
    }

    public InstancePoster postPrimary() {
        InstancePoster poster = new InstancePoster(this.classExtractorMap);
        this.posters.add(poster);
        return poster;
    }
}

