/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.ext;

import net.zomis.fight.ext.WinResult;

public class WinStats
implements Comparable<WinStats> {
    private int wins;
    private int losses;
    private int draws;

    public WinStats() {
        this(0, 0, 0);
    }

    public WinStats(int wins, int losses, int draws) {
        this.wins = wins;
        this.losses = losses;
        this.draws = draws;
    }

    public WinStats copyWith(WinStats combineWith) {
        return new WinStats(this.wins + combineWith.wins, this.losses + combineWith.losses, this.draws + combineWith.draws);
    }

    public void combine(WinStats combineWith) {
        this.wins += combineWith.wins;
        this.losses += combineWith.losses;
        this.draws += combineWith.draws;
    }

    public void add(WinResult result) {
        if (result == null) {
            throw new NullPointerException("Result may not be null");
        }
        switch (result) {
            case WIN: {
                ++this.wins;
                break;
            }
            case LOSS: {
                ++this.losses;
                break;
            }
            case DRAW: {
                ++this.draws;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument for result");
            }
        }
    }

    public int getTotal() {
        return this.wins + this.draws + this.losses;
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getDraws() {
        return this.draws;
    }

    public double getPercentage() {
        double drawsBonus = (double)this.draws / 2.0;
        return ((double)this.wins + drawsBonus) / (double)this.getTotal();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WinStats winStats = (WinStats)o;
        if (this.wins != winStats.wins) {
            return false;
        }
        if (this.losses != winStats.losses) {
            return false;
        }
        return this.draws == winStats.draws;
    }

    public int hashCode() {
        int result = this.wins;
        result = 31 * result + this.losses;
        result = 31 * result + this.draws;
        return result;
    }

    public String toString() {
        return String.format("%d: %d/%d/%d (%.2f %%)", this.getTotal(), this.wins, this.draws, this.losses, this.getPercentage() * 100.0);
    }

    @Override
    public int compareTo(WinStats other) {
        return Double.compare(this.getPercentage(), other.getPercentage());
    }
}

