/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.zomis.fight.FightInterface;
import net.zomis.fight.FightResults;
import net.zomis.fight.GuavaExt;

public class GameFight<T> {
    private final boolean separateIndexes;
    private final String label;

    public GameFight(String label, boolean useSeparateIndexes) {
        this.separateIndexes = useSeparateIndexes;
        this.label = label;
    }

    public GameFight(String label) {
        this(label, false);
    }

    public GameFight() {
        this(null);
    }

    public FightResults<T> fightEvenly(T[] fighters, int gamesPerGroup, FightInterface<T> fightStrategy) {
        FightResults<T> results = new FightResults<T>(this.label, this.separateIndexes);
        List<List<T>> groups = GuavaExt.processSubsets(Arrays.asList(fighters), 2);
        for (List<T> group : groups) {
            int i;
            T[] currentFighters = Arrays.copyOf(fighters, 2);
            currentFighters[0] = group.get(0);
            currentFighters[1] = group.get(1);
            if (currentFighters[0] == currentFighters[1]) {
                throw new UnsupportedOperationException("Fighters cannot be equal at the moment");
            }
            for (i = 1; i <= gamesPerGroup; ++i) {
                results.saveResult(currentFighters, fightStrategy.determineWinner(currentFighters, i));
            }
            if (!this.separateIndexes) continue;
            currentFighters[0] = group.get(1);
            currentFighters[1] = group.get(0);
            for (i = 1; i <= gamesPerGroup; ++i) {
                results.saveResult(currentFighters, fightStrategy.determineWinner(currentFighters, i));
            }
        }
        results.finished();
        return results;
    }

    public FightResults<T> fightRandom(T[] fighters, int count, FightInterface<T> fightStrategy) {
        FightResults<T> results = new FightResults<T>(this.label, this.separateIndexes);
        Random random = new Random();
        for (int i = 1; i <= count; ++i) {
            T[] currentFighters = Arrays.copyOf(fighters, 2);
            ArrayList<T> playerOptions = new ArrayList<T>(Arrays.asList(fighters));
            currentFighters[0] = playerOptions.remove(random.nextInt(playerOptions.size()));
            currentFighters[1] = playerOptions.remove(random.nextInt(playerOptions.size()));
            if (currentFighters[0] == currentFighters[1]) {
                throw new IllegalStateException("Fighters cannot be equal at the moment");
            }
            results.saveResult(currentFighters, fightStrategy.determineWinner(currentFighters, i));
        }
        results.finished();
        return results;
    }
}

