/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.statextract;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.zomis.fight.statextract.CollectorInfo;
import net.zomis.fight.statextract.Poster;
import net.zomis.fight.statextract.types.StatCollector;

public class ClassExtractor {
    final List<CollectorInfo> collectors = new ArrayList<CollectorInfo>();
    private final List<BiConsumer<Poster, Object>> preHandlers = new ArrayList<BiConsumer<Poster, Object>>();

    void add(Poster extractor, Object object) {
        this.preHandlers.forEach(consumer -> consumer.accept(extractor, object));
        for (CollectorInfo collector : this.collectors) {
            collector.accumulate(object);
        }
    }

    public void addCollector(String name, StatCollector statCollector, Supplier<Collector<?, ?, ?>> fieldValue) {
        this.collectors.add(new CollectorInfo(name, statCollector, fieldValue));
    }

    public Map<String, Object> finish() {
        return this.collectors.stream().collect(Collectors.toMap(CollectorInfo::getName, coll -> coll.finish()));
    }

    ClassExtractor copy() {
        ClassExtractor copy = new ClassExtractor();
        for (CollectorInfo collectorInfo : this.collectors) {
            copy.collectors.add(collectorInfo.copy());
        }
        copy.preHandlers.addAll(this.preHandlers);
        return copy;
    }

    void addPreHandler(BiConsumer<Poster, ?> preHandler) {
        this.preHandlers.add(preHandler);
    }
}

