/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.zomis.fight.PlayerResults;

public class FightResults<T> {
    private final Map<T, PlayerResults<T>> playerData = new HashMap<T, PlayerResults<T>>();
    private final boolean separateIndexes;
    private final String label;
    private final long timeStart;
    private long timeEnd;

    public FightResults(String label, boolean separateIndexes) {
        this.label = label;
        this.separateIndexes = separateIndexes;
        this.timeStart = System.nanoTime();
    }

    public List<PlayerResults<T>> getResultsAsc() {
        ArrayList<PlayerResults<T>> list = new ArrayList<PlayerResults<T>>(this.playerData.values());
        Collections.sort(list);
        return list;
    }

    public LinkedHashMap<T, Double> getPercentagesDesc() {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : FightResults.entriesSortedByValues(this.playerData, true)) {
            result.put(entry.getKey(), ((PlayerResults)entry.getValue()).calcTotal().getPercentage());
        }
        return result;
    }

    void finished() {
        this.timeEnd = System.nanoTime();
    }

    public void saveResult(T[] fighters, T winner) {
        boolean DEFAULT_INDEX = false;
        for (int i = 0; i < fighters.length; ++i) {
            T pp1 = fighters[i];
            PlayerResults result = this.playerData.computeIfAbsent(pp1, pl -> new PlayerResults<Object>(pl));
            for (int j = 0; j < fighters.length; ++j) {
                if (i == j) continue;
                result.addResult(this.separateIndexes ? i : 0, fighters[j], winner);
            }
        }
    }

    public String toString() {
        return this.playerData.toString();
    }

    public String toStringMultiLine() {
        StringBuilder str = new StringBuilder();
        if (this.label != null) {
            str.append(this.label);
            str.append("\n");
        }
        str.append(super.toString());
        str.append("\n");
        for (Map.Entry entry : FightResults.entriesSortedByValues(this.playerData, false)) {
            str.append(entry.getKey());
            str.append("\n");
            str.append(((PlayerResults)entry.getValue()).toStringMultiLine());
            str.append("\n");
        }
        double timeSpent = (double)(this.timeEnd - this.timeStart) / 1000000.0;
        str.append("Time spent: " + timeSpent + " milliseconds\n");
        return str.toString();
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map, final boolean descending) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int res = descending ? ((Comparable)e1.getValue()).compareTo(e2.getValue()) : ((Comparable)e2.getValue()).compareTo(e1.getValue());
                return res != 0 ? -res : 1;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }
}

