/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight;

import java.util.HashMap;
import java.util.Map;
import net.zomis.fight.IndexResults;
import net.zomis.fight.WinsLosses;

public class PlayerResults<T>
implements Comparable<PlayerResults<T>> {
    private final T player;
    private final Map<Integer, IndexResults<T>> results = new HashMap<Integer, IndexResults<T>>();

    public T getPlayer() {
        return this.player;
    }

    PlayerResults(T player) {
        this.player = player;
    }

    void addResult(int myIndex, T opponent, T winner) {
        IndexResults result = this.results.computeIfAbsent(myIndex, i -> new IndexResults());
        Boolean winStatus = null;
        if (winner == this.player) {
            winStatus = true;
        } else if (winner != null) {
            winStatus = false;
        }
        result.informAbout(opponent, winStatus);
    }

    public String toStringMultiLine() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<Integer, IndexResults<T>> ee : this.results.entrySet()) {
            str.append("as index ");
            str.append(ee.getKey());
            str.append(": (");
            str.append(ee.getValue().calcTotal());
            str.append(")\n");
            str.append(ee.getValue().toStringMultiLine());
        }
        return str.toString();
    }

    public String toString() {
        return this.results.toString();
    }

    public WinsLosses calcTotal() {
        int wins = 0;
        int losses = 0;
        int draws = 0;
        for (Map.Entry<Integer, IndexResults<T>> ee : this.results.entrySet()) {
            WinsLosses tot = ee.getValue().calcTotal();
            wins += tot.getWins();
            draws = tot.getDraws();
            losses += tot.getLosses();
        }
        return new WinsLosses(wins, losses, draws);
    }

    public double calculatePercentage() {
        return this.calcTotal().getPercentage();
    }

    @Override
    public int compareTo(PlayerResults<T> o) {
        return Double.compare(this.calculatePercentage(), o.calculatePercentage());
    }
}

