/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.ext;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.zomis.fight.ext.FNode;
import net.zomis.fight.ext.FightResHandler;
import net.zomis.fight.ext.Indexer;

public class FightIndexer<T> {
    private final Map<String, FightResHandler<T>> handlers = new LinkedHashMap<String, FightResHandler<T>>();

    public Map<String, FightResHandler<T>> getHandlers() {
        return this.handlers;
    }

    public FightIndexer<T> addIndex(String key, Indexer<T> index) {
        this.checkKey(key);
        this.handlers.put(key, new FightResHandler(f -> index.apply(f.getF()), null));
        return this;
    }

    private void checkKey(String key) {
        if (this.handlers.containsKey(key)) {
            throw new IllegalArgumentException("Key has already been added: " + key);
        }
    }

    public FightIndexer<T> addData(String key, Collector<T, ?, ?> collector) {
        this.checkKey(key);
        Collector<FNode, ?, ?> nodelector = Collectors.mapping(f -> f.getF(), collector);
        this.handlers.put(key, new FightResHandler(null, nodelector));
        return this;
    }

    public void addDataAdvanced(String key, Collector<FNode<T>, ?, ?> collector) {
        this.checkKey(key);
        this.handlers.put(key, new FightResHandler<T>(null, collector));
    }

    public void addIndexPlus(String key, Indexer<FNode<T>> otherAI) {
        this.checkKey(key);
        this.handlers.put(key, new FightResHandler(otherAI, null));
    }
}

