/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight;

import java.util.HashMap;
import java.util.Map;
import net.zomis.fight.WinsLosses;

public class IndexResults<T> {
    private final Map<T, WinsLosses> results = new HashMap<T, WinsLosses>();

    void informAbout(T opponent, Boolean winner) {
        WinsLosses winLoss = this.results.computeIfAbsent(opponent, fn -> new WinsLosses());
        if (winner == null) {
            winLoss.draw();
        } else if (winner.booleanValue()) {
            winLoss.win();
        } else {
            winLoss.loss();
        }
    }

    public String toStringMultiLine() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry<T, WinsLosses> ee : this.results.entrySet()) {
            str.append("vs. ");
            str.append(ee.getKey());
            str.append(": ");
            str.append(ee.getValue());
            str.append("\n");
        }
        return str.toString();
    }

    public String toString() {
        return this.results.toString();
    }

    public WinsLosses calcTotal() {
        return new WinsLosses(this.results.values());
    }
}

