/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.statextract;

import java.util.function.Supplier;
import java.util.stream.Collector;
import net.zomis.fight.statextract.types.StatCollector;

public class CollectorInfo {
    private final String name;
    private Object collectingObject;
    private final Collector<Object, Object, Object> collector;
    private final Supplier<Collector<?, ?, ?>> supplier;
    private final StatCollector statCollector;

    public CollectorInfo(String name, StatCollector statCollector, Supplier<Collector<?, ?, ?>> supplier) {
        this.name = name;
        this.statCollector = statCollector;
        this.supplier = supplier;
        Collector<?, ?, ?> collector = supplier.get();
        this.collector = collector;
        this.collectingObject = collector.supplier().get();
    }

    public void accumulate(Object object) {
        this.collector.accumulator().accept(this.collectingObject, object);
    }

    CollectorInfo combine(CollectorInfo other) {
        CollectorInfo copy = this.copy();
        copy.collectingObject = copy.collector.combiner().apply(copy.collectingObject, other.collectingObject);
        copy.collectingObject = copy.collector.combiner().apply(copy.collectingObject, this.collectingObject);
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public Object finish() {
        return this.collector.finisher().apply(this.collectingObject);
    }

    public CollectorInfo copy() {
        return new CollectorInfo(this.name, this.statCollector, this.supplier);
    }

    public Object getIndexValue() {
        return this.statCollector.getIndexValue(this.finish());
    }
}

