/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.statextract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.zomis.fight.statextract.ClassExtractor;
import net.zomis.fight.statextract.CollectorInfo;
import net.zomis.fight.statextract.ExtractResults;
import net.zomis.fight.statextract.InstancePoster;

public class IndexableResults {
    private final List<InstancePoster> posters;
    private final List<Map<String, CollectorInfo>> collectors;

    public IndexableResults(List<InstancePoster> posters) {
        this.posters = posters;
        this.collectors = new ArrayList<Map<String, CollectorInfo>>();
        for (InstancePoster poster : posters) {
            HashMap<String, CollectorInfo> data = new HashMap<String, CollectorInfo>();
            for (Map.Entry<Class<?>, ClassExtractor> ee : poster.extractors.entrySet()) {
                for (CollectorInfo coll : ee.getValue().collectors) {
                    data.put(coll.getName(), coll);
                }
            }
            this.collectors.add(data);
        }
    }

    public ExtractResults unindexed() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        HashMap<String, CollectorInfo> temp = new HashMap<String, CollectorInfo>();
        BiFunction<CollectorInfo, CollectorInfo, CollectorInfo> remapCollectors = (a, b) -> a.combine((CollectorInfo)b);
        for (Map<String, CollectorInfo> map : this.collectors) {
            for (Map.Entry<String, CollectorInfo> ee : map.entrySet()) {
                temp.merge(ee.getKey(), ee.getValue(), remapCollectors);
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            results.put((String)entry.getKey(), ((CollectorInfo)entry.getValue()).finish());
        }
        return new ExtractResults(null, results);
    }

    public Map<Object, Object> indexBy(String ... fields) {
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        HashMap temp = new HashMap();
        BiFunction<CollectorInfo, CollectorInfo, CollectorInfo> remapCollectors = (a, b) -> a.combine((CollectorInfo)b);
        for (Map<String, CollectorInfo> instance : this.collectors) {
            HashMap<Object, Object> current = results;
            for (int index = 0; index < fields.length; ++index) {
                String indexKey = fields[index];
                CollectorInfo indexCollector = instance.get(indexKey);
                Object indexValue = indexCollector.getIndexValue();
                if (index < fields.length - 1) {
                    throw new UnsupportedOperationException();
                }
                this.mergeEndResults(current, indexValue, instance);
            }
        }
        this.finish(results);
        return results;
    }

    private void finish(Map<Object, Object> results) {
        for (Map.Entry<Object, Object> ee : results.entrySet()) {
            if (ee.getValue() instanceof FinalResults) {
                FinalResults fin = (FinalResults)ee.getValue();
                ee.setValue(fin.finish());
                continue;
            }
            this.finish((Map)ee.getValue());
        }
    }

    private void mergeEndResults(Map<Object, Object> current, Object indexValue, Map<String, CollectorInfo> instance) {
        if (current.get(indexValue) == null) {
            current.put(indexValue, new FinalResults());
        }
        FinalResults fin = (FinalResults)current.get(indexValue);
        fin.merge(instance);
    }

    public List<ExtractResults> getResults() {
        return this.posters.stream().map(po -> po.collect()).collect(Collectors.toList());
    }

    public static class FinalResults {
        private static final BiFunction<CollectorInfo, CollectorInfo, CollectorInfo> remapCollectors = (a, b) -> a.combine((CollectorInfo)b);
        private final Map<String, CollectorInfo> temp = new HashMap<String, CollectorInfo>();

        public void merge(Map<String, CollectorInfo> instance) {
            for (Map.Entry<String, CollectorInfo> ee : instance.entrySet()) {
                this.temp.merge(ee.getKey(), ee.getValue(), remapCollectors);
            }
        }

        public Map<String, Object> finish() {
            HashMap<String, Object> results = new HashMap<String, Object>();
            for (Map.Entry<String, CollectorInfo> ee : this.temp.entrySet()) {
                results.put(ee.getKey(), ee.getValue().finish());
            }
            return results;
        }
    }
}

