/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight;

import java.util.Collection;

public class WinsLosses {
    private int wins;
    private int losses;
    private int draws;

    public WinsLosses() {
        this(0, 0, 0);
    }

    public WinsLosses(int wins, int losses, int draws) {
        this.wins = wins;
        this.losses = losses;
        this.draws = draws;
    }

    public WinsLosses(Collection<WinsLosses> total) {
        this(0, 0, 0);
        for (WinsLosses winlose : total) {
            this.wins += winlose.wins;
            this.losses += winlose.losses;
            this.draws += winlose.draws;
        }
    }

    void win() {
        ++this.wins;
    }

    void loss() {
        ++this.losses;
    }

    public int getTotal() {
        return this.wins + this.draws + this.losses;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getWins() {
        return this.wins;
    }

    public double getPercentage() {
        double drawsBonus = (double)this.draws / 2.0;
        return ((double)this.wins + drawsBonus) / (double)this.getTotal();
    }

    public String toString() {
        return String.format("%d wins, %d draws, %d losses (%.2f %%)", this.wins, this.draws, this.losses, this.getPercentage() * 100.0);
    }

    void draw() {
        ++this.draws;
    }

    public int getDraws() {
        return this.draws;
    }
}

