/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.statextract;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.zomis.fight.statextract.ClassExtractor;
import net.zomis.fight.statextract.IndexableResults;
import net.zomis.fight.statextract.InstancePoster;
import net.zomis.fight.statextract.Poster;

public class Extractor {
    private final Object target;
    private final Map<Class<?>, ClassExtractor> classExtractorMap = new HashMap();
    private final List<InstancePoster> posters = Collections.synchronizedList(new ArrayList());

    private Extractor(Object target) {
        this.target = target;
    }

    public IndexableResults collectIndexable() {
        return new IndexableResults(this.posters);
    }

    public static Extractor extractor(Object target) {
        Extractor extractor = new Extractor(target);
        for (Field field : target.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(target);
                Objects.requireNonNull(fieldValue, "Field cannot be null: " + field.getName());
                if (field.getType() != ToIntFunction.class) continue;
                extractor.addExtractor(field.getName(), Extractor.genericType(field, 0), () -> Collectors.summarizingInt((ToIntFunction)fieldValue));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return extractor;
    }

    private void addExtractor(String name, Class<?> aClass, Supplier<Collector<?, ?, ?>> fieldValue) {
        this.extractFor(aClass).addCollector(name, fieldValue);
    }

    private ClassExtractor extractFor(Class<?> aClass) {
        this.classExtractorMap.putIfAbsent(aClass, new ClassExtractor());
        return this.classExtractorMap.get(aClass);
    }

    private static Class<?> genericType(Field field, int i) {
        Type genericFieldType = field.getGenericType();
        if (!(genericFieldType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Cannot deserialize a Map without generics types");
        }
        ParameterizedType aType = (ParameterizedType)genericFieldType;
        Type[] fieldArgTypes = aType.getActualTypeArguments();
        return (Class)fieldArgTypes[i];
    }

    public <T> void addPreHandler(Class<T> clazz, BiConsumer<Poster, ? super T> preHandler) {
        this.extractFor(clazz).addPreHandler(preHandler);
    }

    public InstancePoster postPrimary() {
        InstancePoster poster = new InstancePoster(this.classExtractorMap);
        this.posters.add(poster);
        return poster;
    }
}

