/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.fight.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collector;
import net.zomis.fight.ext.FNode;
import net.zomis.fight.ext.FightIndexer;
import net.zomis.fight.ext.FightResHandler;
import net.zomis.fight.ext.IndexResults;

public class FightRes<T> {
    private final Map<Object, FightRes<T>> index;
    private final IndexResults data = new IndexResults();
    private final String label;

    public FightRes(String label) {
        this.index = new ConcurrentHashMap<Object, FightRes<T>>();
        this.label = label;
    }

    public boolean hasChilds() {
        return !this.index.isEmpty();
    }

    public IndexResults getData() {
        return this.data;
    }

    public void addFight(T fight, FightIndexer<T> fightIndexer) {
        Map<String, FightResHandler<T>> handlers = fightIndexer.getHandlers();
        HashMap whereToAddData = new HashMap();
        ArrayList nextDepths = new ArrayList();
        FNode<T> rootNode = new FNode<T>(Collections.emptyList(), fight);
        whereToAddData.put(rootNode, this);
        nextDepths.add(rootNode);
        for (Map.Entry<String, FightResHandler<T>> ee : handlers.entrySet()) {
            String key = ee.getKey();
            FightResHandler<T> handler = ee.getValue();
            Function<Object, FightRes> suppl = f -> new FightRes(key + f);
            if (handler.isIndexer()) {
                Function nodex = handler.getIndexer();
                ArrayList oldDepths = new ArrayList(nextDepths);
                oldDepths.stream().forEach(previousDepth -> {
                    Object[] objArr;
                    nextDepths.remove(previousDepth);
                    Object useIndex = nodex.apply((FNode)previousDepth);
                    if (!(useIndex instanceof Object[])) {
                        useIndex = new Object[]{useIndex};
                    }
                    for (Object obj : objArr = (Object[])useIndex) {
                        FightRes newD = ((FightRes)map.get((Object)previousDepth)).index.computeIfAbsent(obj, useIndexValue -> (FightRes)suppl.apply(useIndexValue));
                        List<Object> idx = previousDepth.getChosenIndexes();
                        idx.add(obj);
                        FNode<Object> newNode = new FNode<Object>(idx, fight);
                        nextDepths.add(newNode);
                        whereToAddData.put(newNode, newD);
                    }
                });
            }
            if (handler.isCollector()) {
                Collector<FNode<T>, ?, ?> coll = handler.getCollector();
                for (Map.Entry where : whereToAddData.entrySet()) {
                    ((FightRes)where.getValue()).data.addAdvancedData(key, coll, (FNode)where.getKey());
                }
            }
            if (!handler.isCollector() && !handler.isIndexer()) {
                throw new AssertionError((Object)("Key " + key + " is nuts"));
            }
        }
    }

    public String toString() {
        return "FightRes:" + this.label;
    }

    public String toStringBig() {
        return this.label + this.toString(0);
    }

    public String toString(int indentation) {
        String indent = this.indentStr(indentation);
        StringBuilder str = new StringBuilder();
        str.append("\n");
        str.append(indent);
        str.append("    Data: ");
        str.append(this.data);
        str.append("\n");
        for (Map.Entry<Object, FightRes<T>> ee : this.index.entrySet()) {
            indent = this.indentStr(indentation + 4);
            str.append(indent);
            str.append(ee.getValue().label);
            str.append(": ");
            str.append(ee.getValue().toString(indentation + 4));
        }
        return str.toString();
    }

    private String indentStr(int indentation) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < indentation; ++i) {
            str.append(' ');
        }
        return str.toString();
    }

    public void finish() {
        this.data.finish();
        this.index.values().forEach(fightRes -> fightRes.finish());
    }
}

