/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat;

import com.gistlabs.mechanize.Resource;
import com.gistlabs.mechanize.cookie.Cookie;
import com.gistlabs.mechanize.document.html.HtmlDocument;
import com.gistlabs.mechanize.document.html.HtmlElement;
import com.gistlabs.mechanize.document.json.JsonDocument;
import com.gistlabs.mechanize.impl.MechanizeAgent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.zomis.duga.chat.BotConfiguration;
import net.zomis.duga.chat.BotRoom;
import net.zomis.duga.chat.ChatBot;
import net.zomis.duga.chat.ChatMessage;
import net.zomis.duga.chat.ChatMessageHelper;
import net.zomis.duga.chat.ChatMessageResponse;
import net.zomis.duga.chat.ChatThrottleException;
import net.zomis.duga.chat.LoginFunction;
import net.zomis.duga.chat.ProbablyNotLoggedInException;
import net.zomis.duga.chat.StackExchangeLogin;
import net.zomis.duga.chat.events.DugaEvent;
import net.zomis.duga.chat.events.DugaLoginEvent;
import net.zomis.duga.chat.events.DugaPrepostEvent;
import net.zomis.duga.chat.events.DugaStartedEvent;
import net.zomis.duga.chat.events.DugaStopEvent;
import net.zomis.duga.chat.listen.ChatMessageRetriever;
import net.zomis.duga.chat.listen.StackExchangeFetch;
import net.zomis.duga.chat.state.BotCookie;
import net.zomis.duga.chat.state.BotState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackExchangeChatBot
implements ChatBot {
    private static final Logger LOGGER = LoggerFactory.getLogger(StackExchangeChatBot.class);
    @Deprecated
    private static final BotRoom debugRoom = BotRoom.toRoom("20298");
    private static final int MAX_MESSAGE_LENGTH = 500;
    private static final String MESSAGE_CONTINUATION = "...";
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final BlockingQueue<List<ChatMessage>> messagesQueue = new LinkedBlockingQueue<List<ChatMessage>>();
    private final MechanizeAgent agent;
    private final LoginFunction loginFunction = new StackExchangeLogin();
    private final BotConfiguration configuration;
    private String chatFKey;
    private final Map<Class<?>, List<Consumer<Object>>> handlers = new HashMap();
    private long lastPostedTime = 0L;
    private int currentBurst = 0;

    public StackExchangeChatBot(BotConfiguration config) {
        this.configuration = config;
        this.agent = this.loginFunction.constructAgent(config);
    }

    @Override
    public BotRoom room(String roomId) {
        return new BotRoom(this, roomId);
    }

    @Override
    public void start() {
        this.executorService.submit(() -> {
            try {
                this.login();
                LOGGER.info("Start draining");
                this.executeEvent(new DugaStartedEvent(this));
                this.drainMessagesQueue();
            }
            catch (Exception ex) {
                LOGGER.error("Unable to start bot", (Throwable)ex);
            }
        });
    }

    public void login() {
        this.chatFKey = this.loginFunction.retrieveFKey(this.agent, this.configuration);
        LOGGER.info("Found fkey: " + this.chatFKey);
        this.executeEvent(new DugaLoginEvent(this));
    }

    @Override
    @Deprecated
    public Future<List<ChatMessageResponse>> postChat(List<ChatMessage> messages) {
        Objects.requireNonNull(messages, "messages");
        if (messages.isEmpty()) {
            return null;
        }
        ArrayList<ChatMessage> shortenedMessages = new ArrayList<ChatMessage>();
        BotRoom params = BotRoom.toRoom(messages.get(0).getRoom());
        for (ChatMessage mess : messages) {
            String message = mess.getMessage();
            if (message.length() > 500) {
                List<String> messageTokens = ChatMessageHelper.splitToTokens(message);
                for (String reassembled : ChatMessageHelper.reassembleTokens(messageTokens, 500, MESSAGE_CONTINUATION)) {
                    shortenedMessages.add(new ChatMessage(params, reassembled));
                }
                continue;
            }
            shortenedMessages.add(new ChatMessage(params, message));
        }
        LOGGER.info("Adding messages to queue: " + shortenedMessages);
        this.messagesQueue.add(shortenedMessages);
        return null;
    }

    private ChatMessageResponse attemptPostMessageToChat(ChatMessage message) {
        LOGGER.info("Real message post: " + message);
        Objects.requireNonNull(message, "message");
        ChatMessageResponse response = this.postMessageToChat(message);
        if (response.getException() instanceof ChatThrottleException) {
            ChatThrottleException ex = (ChatThrottleException)response.getException();
            LOGGER.info("Chat throttle. Sleeping for " + ex.getThrottleTiming() + " seconds, then reposting");
            try {
                TimeUnit.SECONDS.sleep(ex.getThrottleTiming());
            }
            catch (InterruptedException ex1) {
                Thread.currentThread().interrupt();
            }
            ChatMessageResponse response2 = this.postMessageToChat(message);
            if (response2.hasException()) {
                LOGGER.error("Failed to post message on retry", (Throwable)response2.getException());
            }
            return response2;
        }
        if (response.getException() instanceof ProbablyNotLoggedInException) {
            LOGGER.warn("Probably not logged in. Logging in and then reposting");
            this.login();
            ChatMessageResponse response2 = this.postMessageToChat(message);
            if (response2.hasException()) {
                LOGGER.error("Failed to post message on retry", (Throwable)response2.getException());
            }
            return response2;
        }
        return response;
    }

    @Override
    public Future<ChatMessageResponse> postAsync(ChatMessage message) {
        this.messagesQueue.add(Collections.singletonList(message));
        return null;
    }

    @Override
    public ChatMessageResponse postNowOnce(ChatMessage message) {
        return this.postMessageToChat(message);
    }

    @Override
    public ChatMessageResponse postNow(ChatMessage message) {
        return this.attemptPostMessageToChat(message);
    }

    private ChatMessageResponse postMessageToChat(ChatMessage message) {
        Resource response;
        Objects.requireNonNull(message, "message");
        HashMap<String, String> parameters = new HashMap<String, String>();
        DugaPrepostEvent prepostEvent = new DugaPrepostEvent(this, message);
        this.executeEvent(prepostEvent);
        if (!prepostEvent.isPerformPost()) {
            return new ChatMessageResponse(-1L, 0L, "CANCELLED");
        }
        String text = prepostEvent.getMessage();
        text = text.replaceAll("access_token=([0-9a-f]+)", "access_token=xxxxxxxxxxxxxx");
        parameters.put("text", text);
        parameters.put("fkey", this.chatFKey);
        LOGGER.info("Okay, here we go!");
        try {
            response = this.agent.post("https://chat.stackexchange.com/chats/" + message.getRoom() + "/messages/new", parameters);
        }
        catch (UnsupportedEncodingException e) {
            return new ChatMessageResponse("UnsupportedEncodingException", e);
        }
        LOGGER.info("Response title: " + response.getTitle());
        if (response instanceof JsonDocument) {
            LOGGER.info(response.toString());
            JsonDocument json = (JsonDocument)response;
            LOGGER.info("Success: " + json.getRoot());
            message.onSuccess(json);
            return new ChatMessageResponse(Long.parseLong(json.getRoot().getChild("id").getValue()), Long.parseLong(json.getRoot().getChild("time").getValue()), json.getRoot().toString());
        }
        if (response instanceof HtmlDocument) {
            HtmlDocument htmlDocument = (HtmlDocument)response;
            LOGGER.error("Failure: " + htmlDocument);
            HtmlElement body = htmlDocument.find("body");
            if (body == null) {
                LOGGER.error("Null body: {}", (Object)htmlDocument);
                return new ChatMessageResponse(htmlDocument.asString(), new NullPointerException("Null Body"));
            }
            if (body.getInnerHtml().contains("You can perform this action again in")) {
                LOGGER.info("Throttling: " + body.getInnerHtml());
                int timing = Integer.parseInt(body.getInnerHtml().replaceAll("You can perform this action again in", "").replaceAll("seconds?\\.?", "").trim());
                return new ChatMessageResponse(body.getInnerHtml(), new ChatThrottleException(timing));
            }
            LOGGER.error("Failure body: {}", (Object)body.getInnerHtml());
            return new ChatMessageResponse(body.getInnerHtml(), new ProbablyNotLoggedInException());
        }
        LOGGER.error("Unknown response: " + response);
        throw new IllegalStateException("unexpected response, response.getClass() = " + response.getClass());
    }

    @Override
    public void stop() {
        this.executeEvent(new DugaStopEvent(this));
        this.executorService.shutdownNow();
    }

    @Override
    public <E extends DugaEvent> void registerListener(Class<E> eventClass, Consumer<E> handler) {
        this.handlers.putIfAbsent(eventClass, new ArrayList());
        this.handlers.get(eventClass).add(e -> handler.accept((DugaEvent)e));
    }

    private void executeEvent(DugaEvent event) {
        List<Consumer<Object>> list = this.handlers.get(event.getClass());
        if (list != null) {
            list.forEach(e -> e.accept(event));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drainMessagesQueue() {
        try {
            while (true) {
                LOGGER.info("Posting drained messages...");
                try {
                    List<ChatMessage> mess = this.messagesQueue.take();
                    LOGGER.info("Retrieved: " + mess);
                    this.postDrainedMessages(mess);
                }
                catch (RuntimeException ex) {
                    LOGGER.warn("Error in drainMessagesQueue", (Throwable)ex);
                    try {
                        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
                        messages.add(new ChatMessage(debugRoom, ex.toString()));
                        messages.addAll(Arrays.stream(ex.getStackTrace()).map(trace -> trace.toString()).map(msg -> new ChatMessage(debugRoom, (String)msg)).limit(5L).collect(Collectors.toList()));
                        this.postDrainedMessages(messages);
                    }
                    catch (RuntimeException messages) {}
                }
            }
        }
        catch (InterruptedException ex) {
            ArrayList drainedMessages = new ArrayList();
            this.messagesQueue.drainTo(drainedMessages);
            drainedMessages.forEach(it -> this.postDrainedMessages((List<ChatMessage>)it));
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void postDrainedMessages(List<ChatMessage> messages) {
        Objects.requireNonNull(messages, "messages");
        LOGGER.info("Attempting to post " + messages);
        if (this.currentBurst + messages.size() >= this.configuration.getChatMaxBurst() || System.currentTimeMillis() < this.lastPostedTime + (long)this.configuration.getChatThrottle()) {
            long sleepTime = this.lastPostedTime + (long)this.configuration.getChatThrottle() - System.currentTimeMillis();
            LOGGER.info("Sleeping for " + sleepTime + " milliseconds");
            try {
                TimeUnit.MILLISECONDS.sleep(sleepTime);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.currentBurst = 0;
        } else {
            this.currentBurst += messages.size();
        }
        messages.forEach(message -> {
            try {
                TimeUnit.MILLISECONDS.sleep(this.configuration.getChatMinimumDelay());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.attemptPostMessageToChat((ChatMessage)message);
        });
        this.lastPostedTime = System.currentTimeMillis();
    }

    public String getFKey() {
        return this.chatFKey;
    }

    public ChatMessageRetriever listener() {
        return new StackExchangeFetch(() -> this.chatFKey);
    }

    public BotState saveState() {
        BotState state = new BotState();
        state.setFkey(this.chatFKey);
        ArrayList<BotCookie> cookies = new ArrayList<BotCookie>();
        for (Cookie cookie : this.agent.cookies()) {
            cookies.add(BotCookie.create(cookie.getName(), cookie.getValue(), cookie.getDomain()));
        }
        state.setCookies(cookies);
        return state;
    }

    public void load(BotState state) {
        this.chatFKey = state.getFkey();
        for (BotCookie cookie : state.getCookies()) {
            this.agent.cookies().addNewCookie(cookie.getName(), cookie.getValue(), cookie.getDomain());
        }
    }
}

