/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.zomis.duga.chat.ChatMessage;

public class ChatMessageHelper {
    private static final int MAX_MESSAGE_LENGTH = 500;
    private static final String MESSAGE_CONTINUATION = "...";
    private static final String LINK_TOKEN_REGEX = "\\[(?>[^\\]]+|(?<=\\\\)])+\\]\\((?:https?|ftp):\\/\\/\\S*(?:\\s+\"(?:[^\"]|(?<=\\\\)\")+\")?\\)";
    private static final String TAG_TOKEN_REGEX = "\\[(meta-)?+tag:[^\\]]++\\]";
    private static final String STRIKETHROUGH_TOKEN_REGEX = "---.*?---";
    private static final String CODE_TOKEN_REGEX = "\\`[^\\`]++\\`";
    private static final String MARKDOWN_TOKEN_REGEX = "[*_]{1,3}.*?[*_]{1,3}";
    private static final String WORD_TOKEN_REGEX = "[^\\s]++";
    private static final String MESSAGE_TOKEN_REGEX = "(\\[(?>[^\\]]+|(?<=\\\\)])+\\]\\((?:https?|ftp):\\/\\/\\S*(?:\\s+\"(?:[^\"]|(?<=\\\\)\")+\")?\\)|\\[(meta-)?+tag:[^\\]]++\\]|[*_]{1,3}.*?[*_]{1,3}|---.*?---|\\`[^\\`]++\\`|[^\\s]++)*";
    private static final Pattern MARKDOWN_TOKENIZER = Pattern.compile("(\\[(?>[^\\]]+|(?<=\\\\)])+\\]\\((?:https?|ftp):\\/\\/\\S*(?:\\s+\"(?:[^\"]|(?<=\\\\)\")+\")?\\)|\\[(meta-)?+tag:[^\\]]++\\]|[*_]{1,3}.*?[*_]{1,3}|---.*?---|\\`[^\\`]++\\`|[^\\s]++)*", 98);

    public static List<ChatMessage> split(ChatMessage chatMessage) {
        List<ChatMessage> shortenedMessages;
        String message = chatMessage.getMessage();
        if (message.length() > 500) {
            List<String> messageTokens = ChatMessageHelper.splitToTokens(message);
            List<String> reassembled = ChatMessageHelper.reassembleTokens(messageTokens, 500, MESSAGE_CONTINUATION);
            shortenedMessages = reassembled.stream().map(chatMessage::createCopy).collect(Collectors.toList());
        } else {
            shortenedMessages = Arrays.asList(chatMessage);
        }
        return shortenedMessages;
    }

    public static List<String> splitToTokens(String message) {
        Matcher m = MARKDOWN_TOKENIZER.matcher(message);
        ArrayList<String> tokens = new ArrayList<String>();
        while (m.find()) {
            String match = m.group(0);
            if (match == null || match.trim().isEmpty()) continue;
            tokens.add(match);
        }
        return tokens;
    }

    public static List<String> reassembleTokens(List<String> tokens, int maxLength, String continuation) {
        ArrayList<String> messages = new ArrayList<String>();
        StringBuilder messageBuilder = new StringBuilder(maxLength);
        for (String token : tokens) {
            if (messageBuilder.length() + token.length() < maxLength - continuation.length()) {
                messageBuilder.append(" " + token);
                continue;
            }
            messageBuilder.append(continuation);
            messages.add(messageBuilder.toString());
            messageBuilder = new StringBuilder(token);
        }
        messages.add(messageBuilder.toString());
        return messages;
    }
}

