/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat;

import com.gistlabs.mechanize.document.json.JsonDocument;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.zomis.duga.chat.BotRoom;
import net.zomis.duga.chat.ChatBot;
import net.zomis.duga.chat.ChatMessageResponse;

public class ChatMessage {
    private final String room;
    private final String message;
    private Consumer<JsonDocument> onSuccess;
    private final ChatBot bot;
    private final BotRoom params;

    public ChatMessage(BotRoom params, String message) {
        this(null, params, message);
    }

    public ChatMessage(ChatBot bot, BotRoom params, String message) {
        this.bot = bot;
        this.params = params;
        this.room = params.getRoomId();
        this.message = message;
        this.onSuccess = null;
    }

    public ChatMessage(BotRoom params, String message, Consumer<JsonDocument> onSuccess) {
        this(null, params, message);
        this.onSuccess = onSuccess;
    }

    public ChatMessage createCopy(String text) {
        return new ChatMessage(this.bot, this.params, text);
    }

    public Future<ChatMessageResponse> post() {
        return this.bot.postAsync(this);
    }

    public ChatMessageResponse postNow() {
        return this.bot.postNow(this);
    }

    public String getMessage() {
        return this.message;
    }

    public String getRoom() {
        return this.room;
    }

    void onSuccess(JsonDocument response) {
        if (this.onSuccess != null) {
            this.onSuccess.accept(response);
        }
    }

    public String toString() {
        return "ChatMessage{room='" + this.room + '\'' + ", message='" + this.message + '\'' + ", params=" + this.params + '}';
    }
}

