/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat;

import com.gistlabs.mechanize.Resource;
import com.gistlabs.mechanize.document.html.HtmlDocument;
import com.gistlabs.mechanize.document.html.form.Form;
import com.gistlabs.mechanize.document.html.form.SubmitButton;
import com.gistlabs.mechanize.impl.MechanizeAgent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.zomis.duga.chat.BotConfiguration;
import net.zomis.duga.chat.LoginFunction;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackExchangeLogin
implements LoginFunction {
    private static final Logger logger = LoggerFactory.getLogger((String)StackExchangeLogin.class.getName());

    @Override
    public MechanizeAgent constructAgent(BotConfiguration configuration) {
        MechanizeAgent agent = new MechanizeAgent();
        agent.getClient().setRedirectStrategy(new RedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return response.getStatusLine().getStatusCode() == 302;
            }

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                logger.info("Redirect. Headers: " + Arrays.toString(response.getAllHeaders()));
                String host = request.getFirstHeader("Host").getValue();
                String location = response.getFirstHeader("Location").getValue();
                String protocol = "https";
                if (location.startsWith("http://") || location.startsWith("https://")) {
                    logger.info("Redirecting to " + location);
                    return new HttpGet(location);
                }
                logger.info("Redirecting to " + protocol + "://" + host + location);
                return new HttpGet(protocol + "://" + host + location);
            }
        });
        agent.getClient().addRequestInterceptor((request, context) -> {
            logger.info("Request to " + request.getRequestLine().getUri());
            if (request.getRequestLine().getUri().equals("/login/global-fallback")) {
                request.addHeader("Referer", configuration.getRootUrl() + "/users/chat-login");
            }
        });
        return agent;
    }

    @Override
    public String retrieveFKey(MechanizeAgent agent, BotConfiguration configuration) {
        this.loginRoot(agent, configuration);
        return this.retrieveFKeyReal(agent, configuration);
    }

    private void loginOpenId(MechanizeAgent agent, BotConfiguration configuration) {
        HtmlDocument openIdLoginPage = (HtmlDocument)agent.get("https://openid.stackexchange.com/account/login");
        logger.info("openIdLoginPage: " + openIdLoginPage);
        logger.info("openIdLoginPage.root: " + openIdLoginPage.getRoot());
        List forms = openIdLoginPage.forms().getAll();
        if (forms.isEmpty()) {
            logger.info("openIdLoginPage result: No form found.");
            return;
        }
        Form loginForm = (Form)forms.get(0);
        loginForm.get("email").setValue(configuration.getBotEmail());
        loginForm.get("password").setValue(configuration.getBotPassword());
        List submitButtons = loginForm.findAll("input[type=submit]", SubmitButton.class);
        HtmlDocument response = (HtmlDocument)loginForm.submit((SubmitButton)submitButtons.get(0));
        logger.info("OpenID login response title: {}", (Object)response.getTitle());
    }

    private void loginRoot(MechanizeAgent agent, BotConfiguration configuration) {
        Resource resource = agent.get(configuration.getRootUrl() + "/users/login");
        if (!(resource instanceof HtmlDocument)) {
            logger.error("Resource not HTML: " + resource);
            logger.error(resource.getResponse().toString());
            try {
                logger.error(IOUtils.toString((InputStream)resource.getInputStream()));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read input input stream.", e);
            }
            throw new RuntimeException("Resource is not HTML: " + resource);
        }
        HtmlDocument rootLoginPage = (HtmlDocument)resource;
        logger.debug(rootLoginPage.asString());
        logger.info("element is " + rootLoginPage.find("input[name='fkey']"));
        String fkey = rootLoginPage.find("input[name='fkey']").getAttribute("value");
        logger.info("fkey loginstep 1: {}", (Object)fkey);
        HashMap<String, String> loginParameters = new HashMap<String, String>();
        loginParameters.put("email", configuration.getBotEmail());
        loginParameters.put("password", configuration.getBotPassword());
        loginParameters.put("fkey", fkey);
        try {
            Resource result = agent.post(configuration.getRootUrl() + "/users/login", loginParameters);
            logger.debug(result.asString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Resource currentUserPage = agent.get(configuration.getRootUrl() + "/users/current");
        HtmlDocument currentUserHtml = (HtmlDocument)currentUserPage;
        logger.debug(currentUserHtml.asString());
        boolean loggedIn = currentUserHtml.find(".js-inbox-button") != null;
        logger.info("Root login attempted resulted in: " + loggedIn);
    }

    private void loginChat(MechanizeAgent agent, BotConfiguration configuration) {
        HtmlDocument chatLoginPage = (HtmlDocument)agent.get(configuration.getRootUrl() + "/users/chat-login");
        Form loginForm = (Form)chatLoginPage.forms().getAll().get(chatLoginPage.forms().getAll().size() - 1);
        List submitButtons = loginForm.findAll("input[type=submit]", SubmitButton.class);
        HtmlDocument response = (HtmlDocument)loginForm.submit((SubmitButton)submitButtons.get(submitButtons.size() - 1));
        logger.info(response.getTitle());
        logger.info("Chat login attempted.");
    }

    private String retrieveFKeyReal(MechanizeAgent agent, BotConfiguration configuration) {
        String url = configuration.getChatUrl() + "/chats/join/favorite";
        logger.info("Trying to fetch fkey from chatUrl: {}", (Object)url);
        HtmlDocument joinFavoritesPage = (HtmlDocument)agent.get(url);
        Form joinForm = (Form)joinFavoritesPage.forms().getAll().get(joinFavoritesPage.forms().getAll().size() - 1);
        return joinForm.get("fkey").getAttribute("value");
    }
}

