/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat.listen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gistlabs.mechanize.Resource;
import com.gistlabs.mechanize.document.json.JsonDocument;
import com.gistlabs.mechanize.document.json.node.JsonNode;
import com.gistlabs.mechanize.impl.MechanizeAgent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.zomis.duga.chat.listen.ChatMessageIncoming;
import net.zomis.duga.chat.listen.ChatMessageRetriever;
import net.zomis.duga.chat.listen.ListenRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackExchangeFetch
implements ChatMessageRetriever {
    private static final Logger logger = LoggerFactory.getLogger(StackExchangeFetch.class);
    private final MechanizeAgent agent = new MechanizeAgent();
    private final Supplier<String> fkey;

    public StackExchangeFetch(Supplier<String> fkey) {
        this.fkey = fkey;
    }

    @Override
    public List<ChatMessageIncoming> fetch(String roomId, int count) {
        Resource response;
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.fkey == null) {
            return null;
        }
        parameters.put("fkey", this.fkey.get());
        parameters.put("mode", "messages");
        parameters.put("msgCount", String.valueOf(count));
        try {
            response = this.agent.post("https://chat.stackexchange.com/chats/" + roomId + "/events", parameters);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (!(response instanceof JsonDocument)) {
            logger.warn("Unexpected response fetching " + roomId + ": " + response);
            return null;
        }
        JsonDocument jsonDocument = (JsonDocument)response;
        JsonNode node = jsonDocument.getRoot();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ListenRoot root = (ListenRoot)mapper.readValue(node.toString(), ListenRoot.class);
            return root.getEvents();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

