/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat.listen;

import java.util.List;
import java.util.function.Consumer;
import net.zomis.duga.chat.BotRoom;
import net.zomis.duga.chat.ChatBot;
import net.zomis.duga.chat.listen.ChatMessageIncoming;
import net.zomis.duga.chat.listen.ChatMessageRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ListenTask.class);
    private static final int NUM_MESSAGES = 10;
    private final ChatBot bot;
    private final String room;
    private final BotRoom params;
    private final ChatMessageRetriever retriever;
    private long lastHandledId;
    private long lastMessageTime;
    private final Consumer<ChatMessageIncoming> handler;

    public ListenTask(ChatBot bot, ChatMessageRetriever retriever, String room, Consumer<ChatMessageIncoming> handler) {
        this.bot = bot;
        this.room = room;
        this.params = bot.room(room);
        this.retriever = retriever;
        this.handler = handler;
    }

    synchronized void latestMessages() {
        List<ChatMessageIncoming> events = this.retriever.fetch(this.room, 10);
        long previousId = this.lastHandledId;
        for (ChatMessageIncoming message : events) {
            message.bot = this.bot;
            message.params = this.params;
            if (message.getMessageId() <= this.lastHandledId) continue;
            this.lastHandledId = Math.max(this.lastHandledId, message.getMessageId());
            this.lastMessageTime = Math.max(this.lastMessageTime, message.getTimestamp());
            if (previousId <= 0L) {
                logger.info("Previous id 0, skipping " + message.getContent());
                continue;
            }
            this.handler.accept(message);
        }
        if (previousId <= 0L) {
            this.bot.postAsync(this.params.message("Monking! (Duga is now listening for commands)"));
        }
    }

    @Override
    public void run() {
        try {
            this.latestMessages();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }
}

