/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat.listen;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.logging.Logger;
import net.zomis.duga.chat.BotRoom;
import net.zomis.duga.chat.ChatBot;
import net.zomis.duga.chat.ChatMessage;
import org.apache.commons.lang3.StringEscapeUtils;

public class ChatMessageIncoming {
    private static final Logger logger = Logger.getLogger(ChatMessageIncoming.class.getCanonicalName());
    @JsonProperty
    private String content;
    @JsonProperty(value="event_type")
    private int eventType;
    @JsonProperty(value="message_id")
    private long messageId;
    @JsonProperty(value="room_id")
    private long roomId;
    @JsonProperty(value="time_stamp")
    private long timestamp;
    @JsonProperty(value="user_id")
    private long userId;
    @JsonProperty(value="parent_id")
    private long parentId;
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="user_name")
    private String userName;
    @JsonProperty(value="message_stars")
    private int messageStars;
    @JsonProperty(value="room_name")
    private String roomName;
    @JsonProperty(value="target_user_id")
    private long targetUserId;
    @JsonProperty(value="show_parent")
    private boolean showParent;
    @JsonProperty(value="message_edits")
    private int messageEdits;
    ChatBot bot;
    BotRoom params;

    public void reply(String message) {
        this.bot.postAsync(this.createReply(message));
    }

    public ChatMessage createReply(String message) {
        return this.params.message(":" + this.messageId + " " + message);
    }

    public void post(String message) {
        this.bot.postAsync(this.params.message(message));
    }

    public void ping(String message) {
        this.bot.postAsync(this.params.message("@" + this.userName + " " + message));
    }

    public String toString() {
        return String.format("Room %s: %s (%d) said %s", this.roomId, this.userName, this.userId, this.content);
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getMessageStars() {
        return this.messageStars;
    }

    public long getId() {
        return this.id;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public long getRoomId() {
        return this.roomId;
    }

    public long getTargetUserId() {
        return this.targetUserId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getUserId() {
        return this.userId;
    }

    public String getContent() {
        return this.content;
    }

    public String getRoomName() {
        return this.roomName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String cleanHTML() {
        return StringEscapeUtils.unescapeHtml4((String)this.content);
    }

    @JsonAnySetter
    public void setProperty(String name, Object value) {
        logger.severe("Cannot set property for ChatMessageIncoming: " + name + " = " + value);
    }

    public BotRoom getParams() {
        return this.params;
    }
}

