/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.zomis.duga.chat.ChatBot;
import net.zomis.duga.chat.ChatMessage;

public class BotRoom {
    private final ChatBot bot;
    private String roomId;

    public BotRoom(ChatBot bot, String roomId) {
        this.bot = bot;
        this.roomId = roomId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    @Deprecated
    public static BotRoom toRoom(String roomId) {
        return new BotRoom(null, roomId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BotRoom that = (BotRoom)o;
        return this.roomId.equals(that.roomId);
    }

    public int hashCode() {
        int result = this.roomId.hashCode();
        return result;
    }

    public String toString() {
        return "Room " + this.roomId;
    }

    public ChatMessage message(String input) {
        return new ChatMessage(this.bot, this, input);
    }

    public List<ChatMessage> messages(String ... messages) {
        return Arrays.stream(messages).map(this::message).collect(Collectors.toList());
    }

    public List<ChatMessage> messages(List<String> messages) {
        return messages.stream().map(this::message).collect(Collectors.toList());
    }
}

