/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat.listen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gistlabs.mechanize.Resource;
import com.gistlabs.mechanize.document.json.JsonDocument;
import com.gistlabs.mechanize.document.json.node.JsonNode;
import com.gistlabs.mechanize.impl.MechanizeAgent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.zomis.duga.chat.StackExchangeChatBot;
import net.zomis.duga.chat.WebhookParameters;
import net.zomis.duga.chat.listen.ChatMessageIncoming;
import net.zomis.duga.chat.listen.ListenRoot;

public class ListenTask
implements Runnable {
    private static final int NUM_MESSAGES = 10;
    private final StackExchangeChatBot bot;
    private final String room;
    private final WebhookParameters params;
    private long lastHandledId;
    private long lastMessageTime;
    private MechanizeAgent agent;
    private final Consumer<ChatMessageIncoming> handler;

    public ListenTask(StackExchangeChatBot bot, String room, Consumer<ChatMessageIncoming> handler) {
        this.bot = bot;
        this.room = room;
        this.params = WebhookParameters.toRoom(room);
        this.agent = new MechanizeAgent();
        this.handler = handler;
    }

    synchronized void latestMessages() {
        ListenRoot root;
        Resource response;
        HashMap<String, String> parameters = new HashMap<String, String>();
        String fkey = this.bot.getFKey();
        if (fkey == null) {
            return;
        }
        parameters.put("fkey", fkey);
        parameters.put("mode", "messages");
        parameters.put("msgCount", String.valueOf(10));
        try {
            response = this.agent.post("http://chat.stackexchange.com/chats/" + this.room + "/events", parameters);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (!(response instanceof JsonDocument)) {
            System.out.println("Unexpected response: " + response);
            return;
        }
        System.out.println("Checking for events in room " + this.room);
        JsonDocument jsonDocument = (JsonDocument)response;
        JsonNode node = jsonDocument.getRoot();
        ObjectMapper mapper = new ObjectMapper();
        try {
            root = (ListenRoot)mapper.readValue(node.toString(), ListenRoot.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<ChatMessageIncoming> events = root.getEvents();
        long previousId = this.lastHandledId;
        for (ChatMessageIncoming message : events) {
            message.bot = this.bot;
            message.params = this.params;
            if (message.getMessageId() <= this.lastHandledId) continue;
            this.lastHandledId = Math.max(this.lastHandledId, message.getMessageId());
            this.lastMessageTime = Math.max(this.lastMessageTime, message.getTimestamp());
            if (previousId <= 0L) {
                System.out.println("Previous id 0, skipping " + message.getContent());
                continue;
            }
            this.handler.accept(message);
        }
        if (previousId <= 0L) {
            this.bot.postAsync(this.params.message("Monking! (Duga is now listening for commands)"));
        }
    }

    @Override
    public void run() {
        try {
            this.latestMessages();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }
}

