/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.duga.chat;

import com.gistlabs.mechanize.Resource;
import com.gistlabs.mechanize.document.html.HtmlDocument;
import com.gistlabs.mechanize.document.html.HtmlElement;
import com.gistlabs.mechanize.document.json.JsonDocument;
import com.gistlabs.mechanize.impl.MechanizeAgent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.zomis.duga.chat.BotConfiguration;
import net.zomis.duga.chat.ChatBot;
import net.zomis.duga.chat.ChatMessage;
import net.zomis.duga.chat.ChatMessageHelper;
import net.zomis.duga.chat.ChatMessageResponse;
import net.zomis.duga.chat.ChatThrottleException;
import net.zomis.duga.chat.LoginFunction;
import net.zomis.duga.chat.ProbablyNotLoggedInException;
import net.zomis.duga.chat.StackExchangeLogin;
import net.zomis.duga.chat.WebhookParameters;
import net.zomis.duga.chat.events.DugaEvent;
import net.zomis.duga.chat.events.DugaStartedEvent;
import net.zomis.duga.chat.events.DugaStopEvent;

public class StackExchangeChatBot
implements ChatBot {
    private static final Logger LOGGER = Logger.getLogger(StackExchangeChatBot.class.getSimpleName());
    @Deprecated
    private static final WebhookParameters debugRoom = WebhookParameters.toRoom("20298");
    private static final int MAX_MESSAGE_LENGTH = 500;
    private static final String MESSAGE_CONTINUATION = "...";
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final BlockingQueue<List<ChatMessage>> messagesQueue = new LinkedBlockingQueue<List<ChatMessage>>();
    private final MechanizeAgent agent;
    private final LoginFunction loginFunction = new StackExchangeLogin();
    private final BotConfiguration configuration;
    private String chatFKey;
    private final Map<Class<?>, List<Consumer<Object>>> handlers = new HashMap();
    private long lastPostedTime = 0L;
    private int currentBurst = 0;

    public StackExchangeChatBot(BotConfiguration config) {
        this.configuration = config;
        this.agent = this.loginFunction.constructAgent(config);
    }

    @Override
    public void start() {
        this.executorService.submit(() -> {
            try {
                this.login();
                System.out.println("Start draining");
                this.executeEvent(new DugaStartedEvent(this));
                this.drainMessagesQueue();
            }
            catch (Exception ex) {
                System.out.println("Error!! " + ex);
                ex.printStackTrace();
            }
        });
    }

    private void login() {
        this.chatFKey = this.loginFunction.retrieveFKey(this.agent, this.configuration);
        LOGGER.info("Found fkey: " + this.chatFKey);
    }

    @Override
    public Future<List<ChatMessageResponse>> postChat(List<ChatMessage> messages) {
        Objects.requireNonNull(messages, "messages");
        if (messages.isEmpty()) {
            return null;
        }
        ArrayList<ChatMessage> shortenedMessages = new ArrayList<ChatMessage>();
        WebhookParameters params = WebhookParameters.toRoom(messages.get(0).getRoom());
        for (ChatMessage mess : messages) {
            String message = mess.getMessage();
            if (message.length() > 500) {
                List<String> messageTokens = ChatMessageHelper.splitToTokens(message);
                for (String reassembled : ChatMessageHelper.reassembleTokens(messageTokens, 500, MESSAGE_CONTINUATION)) {
                    shortenedMessages.add(new ChatMessage(params, reassembled));
                }
                continue;
            }
            shortenedMessages.add(new ChatMessage(params, message));
        }
        System.out.println("Adding messages to queue: " + shortenedMessages);
        this.messagesQueue.add(shortenedMessages);
        return null;
    }

    private ChatMessageResponse attemptPostMessageToChat(ChatMessage message) {
        System.out.println("Real message post: " + message);
        Objects.requireNonNull(message, "message");
        ChatMessageResponse response = this.postMessageToChat(message);
        if (response.getException() instanceof ChatThrottleException) {
            ChatThrottleException ex = (ChatThrottleException)response.getException();
            System.out.println("Chat throttle");
            LOGGER.info("Sleeping for " + ex.getThrottleTiming() + " seconds, then reposting");
            try {
                TimeUnit.SECONDS.sleep(ex.getThrottleTiming());
            }
            catch (InterruptedException ex1) {
                Thread.currentThread().interrupt();
            }
            ChatMessageResponse response2 = this.postMessageToChat(message);
            if (response2.hasException()) {
                LOGGER.log(Level.SEVERE, "Failed to post message on retry", response2.getException());
            }
            return response2;
        }
        if (response.getException() instanceof ProbablyNotLoggedInException) {
            System.out.println("Probably not logged in");
            LOGGER.info("Not logged in, logging in and then reposting");
            this.login();
            ChatMessageResponse response2 = this.postMessageToChat(message);
            if (response2.hasException()) {
                LOGGER.log(Level.SEVERE, "Failed to post message on retry", response2.getException());
            }
            return response2;
        }
        return response;
    }

    @Override
    public Future<ChatMessageResponse> postAsync(ChatMessage message) {
        this.messagesQueue.add(Collections.singletonList(message));
        return null;
    }

    @Override
    public ChatMessageResponse postNowOnce(ChatMessage message) {
        return this.postMessageToChat(message);
    }

    @Override
    public ChatMessageResponse postNow(ChatMessage message) {
        return this.attemptPostMessageToChat(message);
    }

    private ChatMessageResponse postMessageToChat(ChatMessage message) {
        Resource response;
        Objects.requireNonNull(message, "message");
        HashMap<String, String> parameters = new HashMap<String, String>();
        String text = message.getMessage();
        text = text.replaceAll("access_token=([0-9a-f]+)", "access_token=xxxxxxxxxxxxxx");
        parameters.put("text", text);
        parameters.put("fkey", this.chatFKey);
        System.out.println("Okay, here we go!");
        try {
            response = this.agent.post("http://chat.stackexchange.com/chats/" + message.getRoom() + "/messages/new", parameters);
        }
        catch (UnsupportedEncodingException e) {
            return new ChatMessageResponse(e.toString(), e);
        }
        System.out.println("Response: " + response.getTitle());
        if (response instanceof JsonDocument) {
            System.out.println(response);
            JsonDocument json = (JsonDocument)response;
            System.out.println("Success: " + json.getRoot());
            message.onSuccess(json);
            return new ChatMessageResponse(Long.parseLong(json.getRoot().getChild("id").getValue()), Long.parseLong(json.getRoot().getChild("time").getValue()), json.getRoot().toString());
        }
        if (response instanceof HtmlDocument) {
            HtmlDocument htmlDocument = (HtmlDocument)response;
            System.out.println("Failure: " + htmlDocument);
            HtmlElement body = htmlDocument.find("body");
            if (body.getInnerHtml().contains("You can perform this action again in")) {
                int timing = Integer.parseInt(body.getInnerHtml().replaceAll("You can perform this action again in", "").replaceAll("seconds", "").trim());
                return new ChatMessageResponse(body.getInnerHtml(), new ChatThrottleException(timing));
            }
            System.out.println(body.getInnerHtml());
            return new ChatMessageResponse(body.getInnerHtml(), new ProbablyNotLoggedInException());
        }
        System.out.println("Unknown response: " + response);
        throw new IllegalStateException("unexpected response, response.getClass() = " + response.getClass());
    }

    @Override
    public void stop() {
        this.executeEvent(new DugaStopEvent(this));
        this.executorService.shutdownNow();
    }

    @Override
    public <E extends DugaEvent> void registerListener(Class<E> eventClass, Consumer<E> handler) {
        this.handlers.putIfAbsent(eventClass, new ArrayList());
        this.handlers.get(eventClass).add(e -> handler.accept((DugaEvent)e));
    }

    private void executeEvent(DugaEvent event) {
        List<Consumer<Object>> list = this.handlers.get(event.getClass());
        if (list != null) {
            list.forEach(e -> e.accept(event));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drainMessagesQueue() {
        try {
            while (true) {
                System.out.println("Posting drained messages...");
                try {
                    List<ChatMessage> mess = this.messagesQueue.take();
                    System.out.println("Retrieved: " + mess);
                    this.postDrainedMessages(mess);
                    System.out.println("Posted: " + mess);
                }
                catch (RuntimeException ex) {
                    System.out.println("Exception: " + ex);
                    ex.printStackTrace(System.out);
                    try {
                        LOGGER.warning("Error in drainMessagesQueue: " + ex.toString());
                        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
                        messages.add(new ChatMessage(debugRoom, ex.toString()));
                        messages.addAll(Arrays.stream(ex.getStackTrace()).map(trace -> trace.toString()).map(msg -> new ChatMessage(debugRoom, (String)msg)).limit(5L).collect(Collectors.toList()));
                        this.postDrainedMessages(messages);
                    }
                    catch (RuntimeException messages) {}
                }
            }
        }
        catch (InterruptedException ex) {
            ArrayList drainedMessages = new ArrayList();
            this.messagesQueue.drainTo(drainedMessages);
            drainedMessages.forEach(it -> this.postDrainedMessages((List<ChatMessage>)it));
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void postDrainedMessages(List<ChatMessage> messages) {
        Objects.requireNonNull(messages, "messages");
        System.out.println("Attempting to post");
        LOGGER.fine("Attempting to post " + messages);
        if (this.currentBurst + messages.size() >= this.configuration.getChatMaxBurst() || System.currentTimeMillis() < this.lastPostedTime + (long)this.configuration.getChatThrottle()) {
            long sleepTime = this.lastPostedTime + (long)this.configuration.getChatThrottle() - System.currentTimeMillis();
            System.out.println("Sleeping for " + sleepTime);
            LOGGER.info("Sleeping for " + sleepTime + " milliseconds");
            try {
                TimeUnit.MILLISECONDS.sleep(sleepTime);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.currentBurst = 0;
        } else {
            this.currentBurst += messages.size();
        }
        messages.forEach(message -> {
            try {
                TimeUnit.MILLISECONDS.sleep(this.configuration.getChatMinimumDelay());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            this.attemptPostMessageToChat((ChatMessage)message);
        });
        this.lastPostedTime = System.currentTimeMillis();
    }

    public String getFKey() {
        return this.chatFKey;
    }
}

