/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.swing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.zomis.custommap.CustomFacade;
import net.zomis.custommap.model.GenericMapModel;
import net.zomis.custommap.model.ITileModel;
import net.zomis.custommap.view.general.TileInterface;
import net.zomis.custommap.view.general.ViewContainer;
import net.zomis.custommap.view.general.ViewObject;
import net.zomis.custommap.view.swing.ISwingGameView;

public abstract class GameView<TM extends ITileModel<?>>
extends ViewContainer<TM>
implements ISwingGameView {
    public transient JComponent boardView;
    protected GenericMapModel<TM> mapModel;
    public int spacing = 0;
    protected int tileSize = 64;
    public int bgColor = -16777216;
    public List<TileInterface<TM>> map;
    protected float scaleFactorMin = 0.1f;
    protected float scaleFactorMax = 10.0f;
    private int offsetLeft;
    private int offsetTop;

    public GenericMapModel<TM> getMapModel() {
        return this.mapModel;
    }

    @Override
    public JComponent getLayout() {
        return this.boardView;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    @Override
    public int getTileSizeReal() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
        this.repaint();
    }

    public GameView(JPanel view, GenericMapModel<TM> model) {
        this.mapModel = model;
        this.boardView = view;
        this.map = new ArrayList<TileInterface<TM>>();
        if (model.hasMap()) {
            for (ITileModel tv : model) {
                this.map.add(this.newTileView(this, tv));
            }
            this.newTileView(this, (ITileModel)this.getMapModel().pos(0, 0));
        }
    }

    public abstract TileInterface<TM> newTileView(ISwingGameView var1, TM var2);

    public void initTileSize(int parentWidth, int parentHeight, int orientation) {
        this.tileSize = Math.min(parentWidth, parentHeight) / Math.max(this.mapModel.getMapWidth(), this.mapModel.getMapHeight());
        CustomFacade.getLog().i(String.format("initMap: %d x %d. View size %d x %d. Orientation %d. Tile size %d", this.mapModel.getMapWidth(), this.mapModel.getMapHeight(), parentWidth, parentHeight, orientation, this.tileSize));
        this.repaint();
    }

    @Override
    public abstract void repaint();

    @Override
    public int getOffsetLeft() {
        return this.offsetLeft;
    }

    @Override
    public int getOffsetTop() {
        return this.offsetTop;
    }

    @Override
    public void addViewToGame(Object image, boolean backGround) {
        if (image == null) {
            return;
        }
        if (this.boardView == null) {
            return;
        }
        if (backGround) {
            this.boardView.add((Component)((JComponent)image), 0);
        } else {
            this.boardView.add((JComponent)image);
        }
    }

    @Deprecated
    public void scroll(float distanceX, float distanceY) {
        CustomFacade.getLog().v(String.format("Scroll %f, %f", Float.valueOf(distanceX), Float.valueOf(distanceY)));
        this.offsetLeft = (int)((float)this.offsetLeft - distanceX);
        this.offsetTop = (int)((float)this.offsetTop - distanceY);
        if (this.offsetLeft < -150) {
            this.offsetLeft = -150;
        }
        if (this.offsetLeft > 200) {
            this.offsetLeft = 200;
        }
        if (this.offsetTop < -150) {
            this.offsetTop = -150;
        }
        if (this.offsetTop > 200) {
            this.offsetTop = 200;
        }
        this.repaint();
        for (TileInterface<TM> tv : this.map) {
            tv.updatePosition();
        }
    }

    @Override
    public void addViewObject(ViewObject object) {
        if (object.getViewToAdd() == null) {
            CustomFacade.getLog().e("view object is null");
        }
        if (!(object.getViewToAdd() instanceof JComponent)) {
            CustomFacade.getLog().e("GameView ViewObject is wrong: " + object.toString());
        }
        if (this.boardView != null) {
            this.boardView.add((JComponent)object.getViewToAdd());
        }
    }

    @Override
    public void removeViewObject(ViewObject object) {
        if (object == null) {
            CustomFacade.getLog().e("view object is null");
        }
        if (!(object.getViewToAdd() instanceof JComponent)) {
            CustomFacade.getLog().e("GameView ViewObject is wrong: " + object.toString());
        }
        if (this.boardView != null) {
            this.boardView.remove((JComponent)object.getViewToAdd());
        }
    }
}

