/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android;

import android.R;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import java.lang.reflect.Field;
import net.zomis.custommap.CustomFacade;
import net.zomis.custommap.view.android.IAndroidGameView;
import net.zomis.custommap.view.android.MyImageView;
import net.zomis.custommap.view.general.ViewObject;

public class MapPaintable
implements ViewObject,
View.OnTouchListener {
    protected transient MyImageView image;
    private transient int size;
    protected transient IAndroidGameView view;
    protected int x;
    protected int y;

    public Context getContext() {
        return this.image.getContext();
    }

    public MapPaintable(IAndroidGameView g) {
        this.view = g;
        if (g != null) {
            if (g.getLayout() != null && g.getLayout().getContext() != null) {
                this.image = new MyImageView(g.getLayout().getContext());
                this.image.setOnTouchListener(this);
            }
            this.view.addViewObject(this);
            this.setSize(g.getTileSizeScaled());
        }
    }

    @Override
    public int getHeight() {
        return this.size;
    }

    public IAndroidGameView getMap() {
        return this.view;
    }

    public int getSize() {
        return this.size;
    }

    public int getTileSize() {
        if (this.getMap() == null) {
            return this.size;
        }
        return this.getMap().getTileSizeScaled();
    }

    @Override
    public Object getViewToAdd() {
        return this.image;
    }

    @Override
    public int getWidth() {
        return this.size;
    }

    public boolean onTouch(View view, MotionEvent event) {
        this.getMap().onTouch(view, event);
        return false;
    }

    public void remove() {
        if (this.view != null) {
            this.view.removeViewObject(this);
        }
        this.view = null;
        this.image = null;
    }

    public void setImageClick(View.OnClickListener click) {
        this.image.setOnClickListener(click);
    }

    public void setImageTouch(View.OnTouchListener onTouch) {
        this.image.setOnTouchListener(onTouch);
    }

    public void setImageLongClick(View.OnLongClickListener listener) {
        this.image.setOnLongClickListener(listener);
    }

    public void setImageResourceByInt(int resId) {
        this.image.setImageResource(resId);
    }

    @Deprecated
    public void setImageResourceByName(String drawableName) {
        this.setImageResourceByInt(MapPaintable.getImageResourceByName(this.view.getLayout().getContext(), drawableName));
    }

    public static int getImageResourceByName(Context context, String drawableName) {
        if (drawableName.startsWith("android.R.drawable.")) {
            drawableName = drawableName.substring("android.R.drawable.".length());
            try {
                Field f = R.drawable.class.getField(drawableName);
                return f.getInt(null);
            }
            catch (Exception e) {
                CustomFacade.getLog().e("Field error: " + e.getMessage());
                e.printStackTrace();
                return 0;
            }
        }
        return context.getResources().getIdentifier(drawableName, "drawable", context.getPackageName());
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updatePosition();
    }

    public void setPositionCentered(int x, int y) {
        this.setPosition(x - this.getWidth() / 2, y - this.getHeight() / 2);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setVisible(boolean visible) {
        this.image.setVisibility(visible ? 0 : 4);
    }

    public void updatePosition() {
        if (this.view == null) {
            return;
        }
        if (this.image == null) {
            return;
        }
        int left = this.x;
        int top = this.y;
        int right = left + this.getSize();
        int bottom = top + this.getSize();
        this.image.layout(left, top, right, bottom);
    }
}

