/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.utils;

import java.util.Collection;
import java.util.HashSet;
import net.zomis.custommap.CustomFacade;

public class ZomisUtils {
    public static final double EPSILON = 1.0E-6;

    public static double nanoToMilli(long nano) {
        return (double)nano / 1000000.0;
    }

    @Deprecated
    public static String format(Object ... values) {
        StringBuilder str = new StringBuilder();
        for (Object obj : values) {
            str.append(obj);
        }
        return str.toString();
    }

    public static String substr(String str, int index, int length) {
        if (index < 0) {
            index = str.length() + index;
        }
        length = length < 0 ? str.length() + length : index + length;
        if (index > str.length()) {
            return "";
        }
        length = Math.min(length, str.length());
        return str.substring(index, length);
    }

    public static String substr(String str, int index) {
        if (index >= 0) {
            return ZomisUtils.substr(str, index, str.length() - index);
        }
        return ZomisUtils.substr(str, index, -index);
    }

    public static String implode(String string, String[] arr) {
        if (arr == null) {
            return null;
        }
        String ret = "";
        for (String str : arr) {
            if (str == null) continue;
            if (ret.length() > 0) {
                ret = ret + string;
            }
            ret = ret + str;
        }
        return ret;
    }

    public static <E> String implodeArr(String string, E[] arr) {
        if (arr == null) {
            return null;
        }
        String ret = "";
        for (E str : arr) {
            if (str == null) continue;
            if (ret.length() > 0) {
                ret = ret + string;
            }
            ret = ret + str;
        }
        return ret;
    }

    @Deprecated
    public static String echo(Object obj) {
        String str = String.valueOf(obj);
        if (CustomFacade.isInitialized()) {
            CustomFacade.getLog().i(str);
        } else {
            System.out.println(str);
        }
        return str;
    }

    @Deprecated
    public static String dechex(int decimal) {
        return Integer.toString(decimal, 16);
    }

    public static String hexToString(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex Length is not divisible by 2");
        }
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            String str = hex.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static String implode(String string, Iterable<? extends Object> list) {
        if (list == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (Object object : list) {
            if (object == null) continue;
            if (ret.length() > 0) {
                ret.append(string);
            }
            ret.append(object);
        }
        return ret.toString();
    }

    public static int ensureRange(int low, int value, int max) {
        return Math.max(low, Math.min(value, max));
    }

    public static float ensureRange(float low, float value, float max) {
        return Math.max(low, Math.min(value, max));
    }

    public static double NNKKnoDiv(int N, int n, int K, int k) {
        return ZomisUtils.nCr(K, k) * ZomisUtils.nCr(N - K, n - k);
    }

    public static double[] NNKKdistribution(int N, int n, int K) {
        double[] nnkkArray = new double[K + 1];
        for (int i = 0; i <= K; ++i) {
            nnkkArray[i] = ZomisUtils.NNKKwithDiv(N, n, K, i);
        }
        return nnkkArray;
    }

    public static double NNKKwithDiv(int N, int n, int K, int k) {
        return ZomisUtils.NNKKnoDiv(N, n, K, k) / ZomisUtils.nCr(N, n);
    }

    public static double nPr(int n, int r) {
        double result = 1.0;
        for (int i = n; i > n - r; --i) {
            result *= (double)i;
        }
        return result;
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be >= 0 but was " + n);
        }
        if (n <= 1) {
            return 1.0;
        }
        double result = n;
        while (--n > 1) {
            result *= (double)n;
        }
        return result;
    }

    public static double nCr(int n, int r) {
        if (r > n || r < 0) {
            return 0.0;
        }
        if (r == 0 || r == n) {
            return 1.0;
        }
        double start = 1.0;
        for (int i = 0; i < r; ++i) {
            start = start * (double)(n - i) / (double)(r - i);
        }
        return start;
    }

    public static <E> void recursiveAdd(Collection<E> collection, E field, RecursiveInterface<E> recursiveCheck) {
        ZomisUtils.recursiveAdd(collection, field, recursiveCheck, new HashSet());
    }

    private static <E> void recursiveAdd(Collection<E> collection, E field, RecursiveInterface<E> recursiveCheck, Collection<E> recursiveChecked) {
        if (recursiveChecked.contains(field)) {
            return;
        }
        recursiveChecked.add(field);
        if (field == null) {
            return;
        }
        for (E mf : recursiveCheck.getRecursiveFields(field)) {
            if (mf == null) continue;
            if (recursiveCheck.performAdd(field, mf)) {
                collection.add(mf);
            }
            if (!recursiveCheck.performRecursive(field, mf)) continue;
            ZomisUtils.recursiveAdd(collection, mf, recursiveCheck, recursiveChecked);
        }
    }

    public static double normalized(double value, double min, double range) {
        if (range == 0.0) {
            return 0.0;
        }
        return (value - min) / range;
    }

    public static double normalizedSigned(double value, double min, double range) {
        if (range == 0.0) {
            return 0.0;
        }
        return ((value - min) / range - 0.5) * 2.0;
    }

    public static String textAfter(String theString, String after) {
        return ZomisUtils.substr(theString, theString.indexOf(after) + after.length());
    }

    public static String textBefore(String theString, String before) {
        return ZomisUtils.substr(theString, 0, theString.indexOf(before));
    }

    public static String textBetween(String theString, String after, String before) {
        return ZomisUtils.textBefore(ZomisUtils.textAfter(theString, after), before);
    }

    public static Class<?> classFor(Object data) {
        return data == null ? null : data.getClass();
    }

    public static boolean doubleEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static String capitalize(String str) {
        return ZomisUtils.substr(str, 0, 1).toUpperCase() + ZomisUtils.substr(str, 1).toLowerCase();
    }

    public static String capitalizeWords(String str) {
        String[] words;
        StringBuilder result = new StringBuilder(str.length());
        for (String s : words = str.split(" ")) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(ZomisUtils.capitalize(s));
        }
        return result.toString();
    }

    public static int deckCombos(int cardsInDeck, int numCardTypes, int numOfEachType) {
        if (cardsInDeck < 0) {
            return 0;
        }
        if (cardsInDeck == 1) {
            return numCardTypes;
        }
        if (numCardTypes == 1) {
            return numOfEachType >= cardsInDeck ? 1 : 0;
        }
        int result = 0;
        for (int i = 0; i <= numOfEachType; ++i) {
            result += ZomisUtils.deckCombos(cardsInDeck - i, numCardTypes - 1, numOfEachType);
        }
        return result;
    }

    public static interface RecursiveInterface<E> {
        public boolean performAdd(E var1, E var2);

        public boolean performRecursive(E var1, E var2);

        public Collection<E> getRecursiveFields(E var1);
    }
}

