/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.replays;

public abstract class Replay<T, M> {
    protected final T game;
    private String initialization;
    private StringBuilder moves;
    private final String moveSep;

    public Replay(T game, String moveSeparator) {
        if (game == null) {
            throw new NullPointerException("Although tempting, game cannot be null");
        }
        this.game = game;
        this.moveSep = moveSeparator;
        this.moves = new StringBuilder();
    }

    public void addMove(M move) {
        if (this.moves.length() > 0) {
            this.moves.append(this.moveSep);
        }
        this.moves.append(this.getMoveData(move));
    }

    public void addMove(M move, int moveOption) {
        if (this.moves.length() > 0) {
            this.moves.append(this.moveSep);
        }
        this.moves.append(moveOption);
        this.moves.append(':');
        this.moves.append(this.getMoveData(move));
    }

    public abstract String getMoveData(M var1);

    public abstract M getMoveData(String var1);

    public abstract String[] extractMoves(String var1);

    public abstract String getInitialization();

    public abstract void applyInitialization(String var1);

    public void initialize() {
        this.initialization = this.getInitialization();
    }

    public void initialize(String init) {
        this.initialization = init;
        this.applyInitialization(init);
    }

    public void performMoves(String movesData) {
        this.moves = new StringBuilder(movesData);
        for (String str : this.extractMoves(movesData)) {
            M move = this.getMoveData(str);
            this.performMove(move);
        }
    }

    protected abstract void performMove(M var1);

    public String getMoveString() {
        return this.moves.toString();
    }

    public String getInit() {
        return this.initialization;
    }
}

