/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.swing;

import net.zomis.custommap.view.general.ViewObject;
import net.zomis.custommap.view.swing.ISwingGameView;
import net.zomis.custommap.view.swing.ImagePanel;

public class MapPaintable
implements ViewObject {
    protected transient ISwingGameView view;
    protected transient ImagePanel image;
    protected int x;
    protected int y;
    private transient int size;

    public MapPaintable(ISwingGameView gameView) {
        this.view = gameView;
        if (gameView != null) {
            if (gameView.getLayout() == null) {
                throw new AssertionError((Object)"GameView layout is null");
            }
            this.image = new ImagePanel(this);
            gameView.addViewObject(this);
            this.updatePosition();
            this.setSize(gameView.getTileSizeReal());
        }
    }

    public int setImageResourceByName(String drawableName) {
        this.image.setImageFromResourceName(drawableName);
        return 0;
    }

    public ISwingGameView getMap() {
        return this.view;
    }

    public void updatePosition() {
        if (this.view == null) {
            return;
        }
        if (this.image == null) {
            return;
        }
        int left = this.view.getOffsetLeft() + this.x;
        int top = this.view.getOffsetTop() + this.y;
        int right = left + this.getWidth();
        int bottom = top + this.getHeight();
        this.image.setBounds(left, top, right - left, bottom - top);
    }

    protected int getTileSize() {
        return this.getMap().getTileSizeReal();
    }

    public void remove() {
        this.view.removeViewObject(this);
        this.view = null;
        this.image = null;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public int getWidth() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public Object getViewToAdd() {
        return this.image;
    }
}

