/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.utils;

public class ColorUtils {
    public static int colorTween(int start, int stop, double percent) {
        int startR = (start & 0xFF0000) >> 16;
        int startG = (start & 0xFF00) >> 8;
        int startB = start & 0xFF;
        int endR = (stop & 0xFF0000) >> 16;
        int endG = (stop & 0xFF00) >> 8;
        int endB = stop & 0xFF;
        int realR = (int)((double)(endR - startR) * percent);
        int realG = (int)((double)(endG - startG) * percent);
        int realB = (int)((double)(endB - startB) * percent);
        return (realR += startR) << 16 | (realG += startG) << 8 | (realB += startB);
    }

    public static int getR(int color) {
        return (color & 0xFF0000) >> 16;
    }

    public static int getG(int color) {
        return (color & 0xFF00) >> 8;
    }

    public static int getB(int color) {
        return color & 0xFF;
    }

    public static String rgbHex(int r, int g, int b) {
        return ColorUtils.str2(r) + ColorUtils.str2(g) + ColorUtils.str2(b);
    }

    public static String str2(int value) {
        String result = Integer.toString(value, 16);
        while (result.length() < 2) {
            result = "0" + result;
        }
        return result;
    }

    public static int getHighestRGBComponent(Integer color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        return Math.max(r, Math.max(g, b));
    }

    public static int getBestComplementaryColor(Integer color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        r = r >= 128 ? 0 : 255;
        g = g >= 128 ? 0 : 255;
        b = b >= 128 ? 0 : 255;
        return ColorUtils.RGB(r, g, b);
    }

    public static int RGB(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }
}

