/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.mazes;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.zomis.common.IntPoint;
import net.zomis.mazes.MazeHelper;

public class MazeAnalyze<Maze> {
    private final Maze zone;
    private final int[] neighbors;
    private MazeHelper<Maze> helper;

    @Deprecated
    int[][] findFieldUsages() {
        int[][] usage = new int[this.helper.mapWidth(this.zone)][this.helper.mapHeight(this.zone)];
        List<IntPoint> deadEnds = this.getPointsWithNeighbors(1);
        for (IntPoint de : deadEnds) {
            usage[de.getX()][de.getY()] = 1;
        }
        return usage;
    }

    public MazeAnalyze(Maze zone, MazeHelper<Maze> helper) {
        this.zone = zone;
        this.neighbors = new int[12];
        this.helper = helper;
    }

    public int[] getNeighbors() {
        return Arrays.copyOf(this.neighbors, this.neighbors.length);
    }

    public MazeAnalyze<Maze> analyze() {
        for (int ix = 0; ix < this.helper.mapWidth(this.zone); ++ix) {
            for (int iy = 0; iy < this.helper.mapHeight(this.zone); ++iy) {
                int currn = this.getNeighborsFor(ix, iy);
                if (currn < 0) continue;
                int n = currn;
                this.neighbors[n] = this.neighbors[n] + 1;
            }
        }
        int count = 0;
        int sum = 0;
        for (int i = 0; i <= this.getMaxNeighbors(); ++i) {
            count += this.neighbors[i];
            sum += this.neighbors[i] * i;
        }
        this.neighbors[10] = count;
        this.neighbors[11] = sum;
        return this;
    }

    private int getMaxNeighbors() {
        return 4;
    }

    public List<IntPoint> getPointsWithNeighbors(int num) {
        LinkedList<IntPoint> result = new LinkedList<IntPoint>();
        for (int ix = 0; ix < this.helper.mapWidth(this.zone); ++ix) {
            for (int iy = 0; iy < this.helper.mapHeight(this.zone); ++iy) {
                int currn = this.getNeighborsFor(ix, iy);
                if (currn != num) continue;
                result.add(new IntPoint(ix, iy));
            }
        }
        return result;
    }

    public int getNeighborsFor(int ix, int iy) {
        int currn = 0;
        if (!this.helper.isWall(this.zone, ix, iy)) {
            for (int x2 = ix - 1; x2 <= ix + 1; ++x2) {
                for (int y2 = iy - 1; y2 <= iy + 1; ++y2) {
                    if (!this.helper.inZone(this.zone, x2, y2) || Math.abs(x2 - ix) + Math.abs(y2 - iy) != 1 || !this.helper.isFreeSpace(this.zone, x2, y2)) continue;
                    ++currn;
                }
            }
            return currn;
        }
        return -1;
    }
}

