/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android.drag;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.Toast;
import net.zomis.custommap.view.android.drag.DragController;
import net.zomis.custommap.view.android.drag.DragView;
import net.zomis.custommap.view.android.drag.interfaces.DragSource;
import net.zomis.custommap.view.android.drag.interfaces.DropTarget;

public class DeleteZone
extends ImageView
implements DropTarget {
    private DragController mDragController;
    private boolean mEnabled = true;

    public DeleteZone(Context context) {
        super(context);
    }

    public DeleteZone(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DeleteZone(Context context, AttributeSet attrs, int style) {
        super(context, attrs, style);
    }

    public DragController getDragController() {
        return this.mDragController;
    }

    public void setDragController(DragController newValue) {
        this.mDragController = newValue;
    }

    @Override
    public void onDrop(DragSource source, int x, int y, int xOffset, int yOffset, DragView dragView, Object dragInfo) {
        if (this.isEnabled()) {
            this.toast("Moved to trash.");
        }
    }

    @Override
    public void onDragEnter(DragSource source, int x, int y, int xOffset, int yOffset, DragView dragView, Object dragInfo) {
        if (this.isEnabled()) {
            this.setImageLevel(2);
        }
    }

    @Override
    public void onDragOver(DragSource source, int x, int y, int xOffset, int yOffset, DragView dragView, Object dragInfo) {
    }

    @Override
    public void onDragExit(DragSource source, int x, int y, int xOffset, int yOffset, DragView dragView, Object dragInfo) {
        if (this.isEnabled()) {
            this.setImageLevel(1);
        }
    }

    @Override
    public boolean acceptDrop(DragSource source, int x, int y, int xOffset, int yOffset, DragView dragView, Object dragInfo) {
        return this.isEnabled();
    }

    @Override
    public Rect estimateDropLocation(DragSource source, int x, int y, int xOffset, int yOffset, DragView dragView, Object dragInfo, Rect recycle) {
        return null;
    }

    public boolean isEnabled() {
        return this.mEnabled && this.getVisibility() == 0;
    }

    public void setup(DragController controller) {
        this.mDragController = controller;
        if (controller != null) {
            controller.addDropTarget(this);
        }
    }

    public void toast(String msg) {
        Toast.makeText((Context)this.getContext(), (CharSequence)msg, (int)0).show();
    }
}

