/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.os.Environment;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.view.View;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AndroidUtils {
    public static File getSaveDirectory(String appname, String subdir) {
        File externalPath = Environment.getExternalStorageDirectory();
        File f = subdir == null ? new File(externalPath.getAbsolutePath() + "/" + appname) : new File(externalPath.getAbsolutePath() + "/" + appname + "/" + subdir);
        f.mkdirs();
        return f;
    }

    public static int dpToPixels(int dp, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return dp * (metrics.densityDpi / 160);
    }

    public static File findUnusedFilename(File saveDirectory, String name, String extension) {
        File file;
        String str = "";
        int i = 0;
        do {
            file = new File(saveDirectory, name + str + extension);
            str = Integer.toString(i++);
        } while (file.exists());
        return file;
    }

    public static Bitmap loadBitmapFromView(View v) {
        int w = v.getWidth();
        int h = v.getHeight();
        Bitmap b = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas c = new Canvas(b);
        v.layout(0, 0, w, h);
        v.draw(c);
        return b;
    }

    public static String getSignature(PackageManager packageManager, String packageName) {
        try {
            PackageInfo info = packageManager.getPackageInfo(packageName, 64);
            Signature[] signatureArray = info.signatures;
            int n = signatureArray.length;
            int n2 = 0;
            if (n2 < n) {
                Signature signature = signatureArray[n2];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)0);
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Bitmap screenshot(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap b = view.getDrawingCache();
        if (b != null) {
            return b;
        }
        view.setDrawingCacheEnabled(true);
        view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        view.buildDrawingCache(true);
        Bitmap cache = view.getDrawingCache();
        if (cache == null) {
            return AndroidUtils.loadBitmapFromView(view);
        }
        b = Bitmap.createBitmap((Bitmap)cache);
        view.destroyDrawingCache();
        view.setDrawingCacheEnabled(false);
        return b;
    }

    public static Bitmap toGrayscale(Bitmap original) {
        return AndroidUtils.bitmapFilter(original, (ColorMatrixColorFilter)null);
    }

    public static Bitmap bitmapFilter(Bitmap original, float[] matrix) {
        return AndroidUtils.bitmapFilter(original, new ColorMatrixColorFilter(matrix));
    }

    public static Bitmap bitmapFilter(Bitmap original, ColorMatrixColorFilter cmcf) {
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)original.getWidth(), (int)original.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        if (cmcf == null) {
            ColorMatrix cm = new ColorMatrix();
            cm.setSaturation(0.0f);
            cmcf = new ColorMatrixColorFilter(cm);
        }
        paint.setColorFilter((ColorFilter)cmcf);
        c.drawBitmap(original, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }
}

