/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.common;

import net.zomis.interfaces.HasPos;

public class IntPoint
implements HasPos {
    protected int x;
    protected int y;

    public IntPoint() {
        this(0, 0);
    }

    public IntPoint(IntPoint copy) {
        this(copy.x, copy.y);
    }

    public IntPoint(int coordx, int coordy) {
        this.set(coordx, coordy);
    }

    public void set(int coordx, int coordy) {
        this.x = coordx;
        this.y = coordy;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public IntPoint dxdy(int dx, int dy) {
        return new IntPoint(this.x + dx, this.y + dy);
    }

    public IntPoint dxdy(IntPoint delta) {
        return new IntPoint(this.x + delta.x, this.y + delta.y);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "]";
    }

    public void set(IntPoint value) {
        this.set(value.x, value.y);
    }

    public int distanceSquared(IntPoint other) {
        int dx = other.x - this.x;
        int dy = other.y - this.y;
        return dx * dx + dy * dy;
    }

    public double distance(IntPoint other) {
        return Math.sqrt(this.distanceSquared(other));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HasPos)) {
            return false;
        }
        HasPos other = (HasPos)obj;
        return this.x == other.getX() && this.y == other.getY();
    }
}

