/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import net.zomis.utils.MD5Util;

public class ZomisUtils2 {
    public static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static String md5(String string) {
        return ZomisUtils2.md5(string.getBytes());
    }

    public static String md5(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] thedigest = md.digest(bytes);
            return MD5Util.toHEX(thedigest, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String date(String dateFormat, Date date) {
        SimpleDateFormat sdf = dateFormat == null ? new SimpleDateFormat(DEFAULT_DATE_FORMAT) : new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    public static String date(String string, long datetime) {
        Calendar time = Calendar.getInstance();
        time.setTimeInMillis(datetime);
        return ZomisUtils2.date(string, time.getTime());
    }

    public static String date(String string) {
        return ZomisUtils2.date(string, Calendar.getInstance().getTimeInMillis());
    }

    public static String date() {
        return ZomisUtils2.date(DEFAULT_DATE_FORMAT);
    }

    public static long getSeed(Random random) {
        int j;
        int i;
        byte[] bar;
        byte[] ba1;
        byte[] ba0;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(new Random(0L));
            ba0 = baos.toByteArray();
            baos = new ByteArrayOutputStream(128);
            oos = new ObjectOutputStream(baos);
            oos.writeObject(new Random(-1L));
            ba1 = baos.toByteArray();
            baos = new ByteArrayOutputStream(128);
            oos = new ObjectOutputStream(baos);
            oos.writeObject(random);
            bar = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e);
        }
        if (ba0.length != ba1.length || ba0.length != bar.length) {
            throw new RuntimeException("bad serialized length");
        }
        for (i = 0; i < ba0.length && ba0[i] == ba1[i]; ++i) {
        }
        for (j = ba0.length; j > 0 && ba0[j - 1] == ba1[j - 1]; --j) {
        }
        if (j - i != 6) {
            throw new RuntimeException("6 differing bytes not found");
        }
        return (((long)bar[i] & 0xFFL) << 40 | ((long)bar[i + 1] & 0xFFL) << 32 | ((long)bar[i + 2] & 0xFFL) << 24 | ((long)bar[i + 3] & 0xFFL) << 16 | ((long)bar[i + 4] & 0xFFL) << 8 | (long)bar[i + 5] & 0xFFL) ^ 0x5DEECE66DL;
    }

    @Deprecated
    public static <T> T objAs(Object object, Class<T> to) {
        if (object == null) {
            return null;
        }
        if (to.isAssignableFrom(object.getClass())) {
            return to.cast(object);
        }
        return null;
    }

    public static String coloredText(String text, int color) {
        return String.format("<font color=\"#%s\">%s</font>", Integer.toString(color, 16), text);
    }
}

