/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.events;

import net.zomis.events.EventConsumer;
import net.zomis.events.EventListener;
import net.zomis.events.IEvent;
import net.zomis.events.IEventHandler;

public class EventHandlerIface<T extends IEvent>
implements IEventHandler,
EventListener,
Comparable<IEventHandler> {
    private final EventConsumer<T> consumer;
    private final int priority;

    public EventHandlerIface(EventConsumer<T> consumer) {
        this(consumer, 50);
    }

    public EventHandlerIface(EventConsumer<T> handler, int priority) {
        this.consumer = handler;
        this.priority = priority;
    }

    @Override
    public final void execute(IEvent event) {
        this.executeEvent(event);
    }

    public void executeEvent(T event) {
        this.consumer.executeEvent(event);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public EventListener getListener() {
        return this;
    }

    @Override
    public int compareTo(IEventHandler other) {
        int compare = 0;
        if (compare == 0) {
            compare = this.getPriority() - other.getPriority();
        }
        if (compare == 0) {
            compare = this.getListener().hashCode() - other.getListener().hashCode();
        }
        if (compare == 0) {
            compare = this.hashCode() - other.hashCode();
        }
        return compare;
    }
}

