/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.zomis.interfaces.Garbagable;
import net.zomis.iterate.IndexIterator;
import net.zomis.iterate.IndexIteratorStatus;
import net.zomis.iterate.MapListIterator;

public abstract class GenericMapModel<TM extends Garbagable>
implements Iterable<TM> {
    protected List<List<TM>> map;
    private int mapHeight = 5;
    private int mapWidth = 5;
    private static Random random = new Random();

    protected void setMapWidth(int mapWidth) {
        this.mapWidth = mapWidth;
    }

    protected void setMapHeight(int mapHeight) {
        this.mapHeight = mapHeight;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public boolean hasMap() {
        return this.map != null;
    }

    public boolean initMap(int mapWidth, int mapHeight) {
        this.mapWidth = mapWidth;
        this.mapHeight = mapHeight;
        this.map = new ArrayList<List<TM>>(mapWidth);
        for (int xx = 0; xx < mapWidth; ++xx) {
            this.map.add(xx, new ArrayList(mapHeight));
        }
        for (int yy = 0; yy < mapHeight; ++yy) {
            for (int xx = 0; xx < mapWidth; ++xx) {
                TM t = this.newTile(this, xx, yy);
                this.map.get(xx).add(yy, t);
            }
        }
        return true;
    }

    @Override
    public Iterator<TM> iterator() {
        return new MapListIterator(this.map);
    }

    protected abstract TM newTile(GenericMapModel<TM> var1, int var2, int var3);

    public TM pos(int xpos, int ypos) {
        if (this.map == null) {
            return null;
        }
        if (xpos < 0) {
            return null;
        }
        if (ypos < 0) {
            return null;
        }
        if (xpos >= this.mapWidth) {
            return null;
        }
        if (ypos >= this.mapHeight) {
            return null;
        }
        return (TM)((Garbagable)this.map.get(xpos).get(ypos));
    }

    public TM posRandom() {
        int x = random.nextInt(this.mapWidth);
        int y = random.nextInt(this.mapHeight);
        return this.pos(x, y);
    }

    protected void changeSize(int newWidth, int newHeight) {
        int numAddWidth = newWidth - this.getMapWidth();
        if (numAddWidth >= 0) {
            this.ensureExistingHeights(newHeight);
            for (int i = 0; i < numAddWidth; ++i) {
                ArrayList<TM> list = new ArrayList<TM>(newHeight);
                for (int yy = 0; yy < newHeight; ++yy) {
                    TM tm = this.newTile(this, this.getMapWidth() + i, yy);
                    list.add(tm);
                }
                this.map.add(list);
            }
        } else {
            int i;
            for (i = 0; i < -numAddWidth; ++i) {
                List<TM> list = this.map.get(newWidth + i);
                for (Garbagable bt : list) {
                    bt.javaGarbage();
                }
                list.clear();
            }
            for (i = 0; i < -numAddWidth; ++i) {
                this.map.remove(this.map.size() - 1);
            }
            this.ensureExistingHeights(newHeight);
        }
        this.mapWidth = newWidth;
        this.mapHeight = newHeight;
    }

    private void ensureExistingHeights(int newHeight) {
        int numAddHeight = newHeight - this.getMapHeight();
        if (numAddHeight >= 0) {
            for (IndexIteratorStatus<List<TM>> indexIteratorStatus : new IndexIterator<List<TM>>(this.map)) {
                for (int yy = 0; yy < numAddHeight; ++yy) {
                    TM tm = this.newTile(this, indexIteratorStatus.getIndex(), this.getMapHeight() + yy);
                    indexIteratorStatus.getValue().add(tm);
                }
            }
        } else {
            for (List<TM> list : this.map) {
                for (int i = 0; i < -numAddHeight; ++i) {
                    Garbagable bt = (Garbagable)list.remove(list.size() - 1);
                    bt.javaGarbage();
                }
            }
        }
    }

    public void javaGarbage() {
        if (this.map != null) {
            for (List<TM> list : this.map) {
                list.clear();
            }
            this.map.clear();
            this.map = null;
        }
    }
}

