/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.common;

import net.zomis.interfaces.HasPos;

public class ImmutablePoint
implements HasPos {
    private final int x;
    private final int y;

    public ImmutablePoint(HasPos pos) {
        this(pos.getX(), pos.getY());
    }

    public ImmutablePoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HasPos)) {
            return false;
        }
        HasPos other = (HasPos)obj;
        return this.x == other.getX() && this.y == other.getY();
    }

    public ImmutablePoint dxdy(int dx, int dy) {
        return new ImmutablePoint(this.x + dx, this.y + dy);
    }

    public ImmutablePoint dxdy(HasPos delta) {
        return new ImmutablePoint(this.x + delta.getX(), this.y + delta.getY());
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

