/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.common;

import net.zomis.common.IntPoint;

public enum Direction4 {
    LEFT(-1, 0),
    RIGHT(1, 0),
    UP(0, -1),
    DOWN(0, 1);

    private int dx;
    private int dy;

    private Direction4(int dx, int dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public int getDeltaX() {
        return this.dx;
    }

    public int getDeltaY() {
        return this.dy;
    }

    public Direction4 getOpposite() {
        return Direction4.direction(0, 0, -this.dx, -this.dy);
    }

    public Direction4 getRotation90() {
        return Direction4.direction(0, 0, -this.dy, this.dx);
    }

    public int getDegreeRotation() {
        if (this == LEFT) {
            return 180;
        }
        if (this == UP) {
            return 90;
        }
        if (this == RIGHT) {
            return 0;
        }
        if (this == DOWN) {
            return 270;
        }
        throw new UnsupportedOperationException("Since when did 4 directions become more than 4 ?");
    }

    public static Direction4 direction(int oldX, int oldY, int newX, int newY) {
        if (oldX > newX) {
            return LEFT;
        }
        if (oldX < newX) {
            return RIGHT;
        }
        if (oldY > newY) {
            return UP;
        }
        if (oldY < newY) {
            return DOWN;
        }
        return null;
    }

    public void addToIntPoint(IntPoint ip) {
        ip.set(ip.getX() + this.dx, ip.getY() + this.dy);
    }

    public char toChar() {
        return this.toString().charAt(0);
    }
}

