/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.zomis.utils.ZomisList;

public class Best<T> {
    private T best;
    private final List<T> bestList;
    private final Comparator<T> comparator;

    public Best() {
        this(null);
    }

    public Best(Comparator<T> comparator) {
        this.comparator = comparator;
        this.bestList = new ArrayList<T>();
    }

    public boolean add(T object) {
        int compare;
        if (this.best == null) {
            this.best = object;
            return true;
        }
        if (this.comparator == null) {
            Comparable a = (Comparable)object;
            Comparable b = (Comparable)this.best;
            compare = a.compareTo(b);
        } else {
            compare = this.comparator.compare(object, this.best);
        }
        if (compare > 0) {
            this.best = object;
            this.bestList.clear();
            this.bestList.add(object);
        } else if (compare == 0) {
            this.bestList.add(object);
        } else {
            return false;
        }
        return true;
    }

    public T getTheBest() {
        return this.best;
    }

    public T getRandomBest() {
        return ZomisList.getRandom(this.bestList);
    }

    public T getRandomBest(Random random) {
        return ZomisList.getRandom(this.bestList, random);
    }

    public List<T> getAllBest() {
        return new ArrayList<T>(this.bestList);
    }
}

