/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.zomis.custommap.CustomFacade;
import net.zomis.events.Event;
import net.zomis.events.EventException;
import net.zomis.events.EventListener;
import net.zomis.events.IEvent;
import net.zomis.events.IEventHandler;

public class EventHandler
implements IEventHandler {
    private final EventListener listener;
    private final Method method;
    private final Event annotation;
    private final boolean propagateExceptions;

    protected EventHandler() {
        this(null, null, null);
    }

    public EventHandler(EventListener listener, Method method, Event annotation) {
        this(listener, method, annotation, null);
    }

    public EventHandler(EventListener listener, Method method, Event annotation, Boolean propagateExceptions) {
        this.listener = listener;
        this.method = method;
        this.annotation = annotation;
        this.propagateExceptions = propagateExceptions == null ? annotation.propagateExceptions() : propagateExceptions.booleanValue();
    }

    @Override
    public EventListener getListener() {
        return this.listener;
    }

    @Override
    public void execute(IEvent event) {
        block4: {
            try {
                this.method.invoke((Object)this.listener, event);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(this.errorString(event), e1);
            }
            catch (IllegalArgumentException e1) {
                throw new RuntimeException(this.errorString(event), e1);
            }
            catch (InvocationTargetException e1) {
                CustomFacade.getLog().e(this.errorString(event), e1.getCause());
                if (!this.propagateExceptions) break block4;
                throw new EventException(this.errorString(event), e1.getCause());
            }
        }
    }

    private final String errorString(IEvent event) {
        return "Exception when executing " + this.method.getName() + " in listener " + this.listener + " for event " + event;
    }

    public String toString() {
        return "(EventHandler " + this.listener + ": " + this.method.getName() + ")";
    }

    @Override
    public int getPriority() {
        return this.annotation == null ? 50 : this.annotation.priority();
    }

    @Override
    public int compareTo(IEventHandler other) {
        int compare = 0;
        if (compare == 0) {
            compare = this.getPriority() - other.getPriority();
        }
        if (compare == 0) {
            compare = this.getListener().hashCode() - other.getListener().hashCode();
        }
        if (compare == 0) {
            compare = this.hashCode() - other.hashCode();
        }
        return compare;
    }
}

