/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.android;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import net.zomis.android.IScaleGestureDetector;
import net.zomis.android.OnScaleGestureListener;

public class MyScaleGestureDetector
implements IScaleGestureDetector {
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private final Context mContext;
    private final OnScaleGestureListener mListener;
    private boolean mGestureInProgress;
    private MotionEvent mPrevEvent;
    private MotionEvent mCurrEvent;
    private float mFocusX;
    private float mFocusY;
    private float mPrevFingerDiffX;
    private float mPrevFingerDiffY;
    private float mCurrFingerDiffX;
    private float mCurrFingerDiffY;
    private float mCurrLen;
    private float mPrevLen;
    private float mScaleFactor;
    private float mCurrPressure;
    private float mPrevPressure;
    private long mTimeDelta;
    private final float mEdgeSlop;
    private float mRightSlopEdge;
    private float mBottomSlopEdge;
    private boolean mSloppyGesture;

    public MyScaleGestureDetector(Context context, OnScaleGestureListener listener) {
        ViewConfiguration config = ViewConfiguration.get((Context)context);
        this.mContext = context;
        this.mListener = listener;
        this.mEdgeSlop = config.getScaledEdgeSlop();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        boolean handled = true;
        if (!this.mGestureInProgress) {
            switch (action & 0xFF) {
                case 5: {
                    boolean p1sloppy;
                    DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
                    this.mRightSlopEdge = (float)metrics.widthPixels - this.mEdgeSlop;
                    this.mBottomSlopEdge = (float)metrics.heightPixels - this.mEdgeSlop;
                    this.reset();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                    this.mTimeDelta = 0L;
                    this.setContext(event);
                    float edgeSlop = this.mEdgeSlop;
                    float rightSlop = this.mRightSlopEdge;
                    float bottomSlop = this.mBottomSlopEdge;
                    float x0 = event.getRawX();
                    float y0 = event.getRawY();
                    float x1 = MyScaleGestureDetector.getRawX(event, 1);
                    float y1 = MyScaleGestureDetector.getRawY(event, 1);
                    boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                    boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                    if (p0sloppy && p1sloppy) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        this.mSloppyGesture = true;
                        break;
                    }
                    if (p0sloppy) {
                        this.mFocusX = MyScaleGestureDetector.getRawX(event, 1);
                        this.mFocusY = MyScaleGestureDetector.getRawY(event, 1);
                        this.mSloppyGesture = true;
                        break;
                    }
                    if (p1sloppy) {
                        this.mFocusX = MyScaleGestureDetector.getRawX(event, 0);
                        this.mFocusY = MyScaleGestureDetector.getRawY(event, 0);
                        this.mSloppyGesture = true;
                        break;
                    }
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    break;
                }
                case 2: {
                    boolean p1sloppy;
                    if (!this.mSloppyGesture) break;
                    float edgeSlop = this.mEdgeSlop;
                    float rightSlop = this.mRightSlopEdge;
                    float bottomSlop = this.mBottomSlopEdge;
                    float x0 = event.getRawX();
                    float y0 = event.getRawY();
                    float x1 = MyScaleGestureDetector.getRawX(event, 1);
                    float y1 = MyScaleGestureDetector.getRawY(event, 1);
                    boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                    boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                    if (p0sloppy && p1sloppy) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        break;
                    }
                    if (p0sloppy) {
                        this.mFocusX = MyScaleGestureDetector.getRawX(event, 1);
                        this.mFocusY = MyScaleGestureDetector.getRawY(event, 1);
                        break;
                    }
                    if (p1sloppy) {
                        this.mFocusX = MyScaleGestureDetector.getRawX(event, 0);
                        this.mFocusY = MyScaleGestureDetector.getRawY(event, 0);
                        break;
                    }
                    this.mSloppyGesture = false;
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    break;
                }
                case 6: {
                    if (!this.mSloppyGesture) break;
                    int id = (action & 0xFF00) >> 8 == 0 ? 1 : 0;
                    this.mFocusX = MyScaleGestureDetector.getRawX(event, id);
                    this.mFocusY = MyScaleGestureDetector.getRawY(event, id);
                }
            }
        } else {
            switch (action & 0xFF) {
                case 6: {
                    this.setContext(event);
                    int id = (action & 0xFF00) >> 8 == 0 ? 1 : 0;
                    this.mFocusX = MyScaleGestureDetector.getRawX(event, id);
                    this.mFocusY = MyScaleGestureDetector.getRawY(event, id);
                    if (!this.mSloppyGesture) {
                        this.mListener.onScaleEnd(this);
                    }
                    this.reset();
                    break;
                }
                case 3: {
                    if (!this.mSloppyGesture) {
                        this.mListener.onScaleEnd(this);
                    }
                    this.reset();
                    break;
                }
                case 2: {
                    boolean updatePrevious;
                    this.setContext(event);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onScale(this))) break;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                }
            }
        }
        return handled;
    }

    private static float getRawX(MotionEvent event, int pointerIndex) {
        if (event.getPointerCount() < pointerIndex + 1) {
            return MyScaleGestureDetector.getRawX(event, pointerIndex - 1);
        }
        float offset = event.getRawX() - event.getX();
        return event.getX(pointerIndex) + offset;
    }

    private static float getRawY(MotionEvent event, int pointerIndex) {
        if (event.getPointerCount() < pointerIndex + 1) {
            return MyScaleGestureDetector.getRawY(event, pointerIndex - 1);
        }
        float offset = event.getRawY() - event.getY();
        return event.getY(pointerIndex) + offset;
    }

    private void setContext(MotionEvent curr) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)curr);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        MotionEvent prev = this.mPrevEvent;
        float px0 = MyScaleGestureDetector.getRawX(prev, 0);
        float py0 = MyScaleGestureDetector.getRawY(prev, 0);
        float px1 = MyScaleGestureDetector.getRawX(prev, 1);
        float py1 = MyScaleGestureDetector.getRawY(prev, 1);
        float cx0 = MyScaleGestureDetector.getRawX(curr, 0);
        float cy0 = MyScaleGestureDetector.getRawY(curr, 0);
        float cx1 = MyScaleGestureDetector.getRawX(curr, 1);
        float cy1 = MyScaleGestureDetector.getRawY(curr, 1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.mPrevFingerDiffX = pvx;
        this.mPrevFingerDiffY = pvy;
        this.mCurrFingerDiffX = cvx;
        this.mCurrFingerDiffY = cvy;
        this.mFocusX = cx0 + cvx * 0.5f;
        this.mFocusY = cy0 + cvy * 0.5f;
        this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
        this.mCurrPressure = curr.getPressure(0) + curr.getPressure(1);
        this.mPrevPressure = prev.getPressure(0) + prev.getPressure(1);
    }

    private void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mSloppyGesture = false;
        this.mGestureInProgress = false;
    }

    @Override
    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    @Override
    public float getFocusX() {
        return this.mFocusX;
    }

    @Override
    public float getFocusY() {
        return this.mFocusY;
    }

    @Override
    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float cvx = this.mCurrFingerDiffX;
            float cvy = this.mCurrFingerDiffY;
            this.mCurrLen = (float)Math.sqrt(cvx * cvx + cvy * cvy);
        }
        return this.mCurrLen;
    }

    @Override
    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float pvx = this.mPrevFingerDiffX;
            float pvy = this.mPrevFingerDiffY;
            this.mPrevLen = (float)Math.sqrt(pvx * pvx + pvy * pvy);
        }
        return this.mPrevLen;
    }

    @Override
    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    @Override
    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    @Override
    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }
}

