/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.events;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.zomis.custommap.CustomFacade;
import net.zomis.events.Event;
import net.zomis.events.EventConsumer;
import net.zomis.events.EventHandler;
import net.zomis.events.EventHandlerIface;
import net.zomis.events.EventListener;
import net.zomis.events.IEvent;
import net.zomis.events.IEventExecutor;
import net.zomis.events.IEventHandler;

public class EventExecutor
implements IEventExecutor {
    protected final Map<Class<? extends IEvent>, Collection<IEventHandler>> bindings = new HashMap<Class<? extends IEvent>, Collection<IEventHandler>>();
    private final Set<EventListener> registeredListeners = new HashSet<EventListener>();
    private boolean debug = false;
    private static final EventHandler[] EMPTYHANDLERS = new EventHandler[0];

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Deprecated
    public IEventHandler[] getListenersFor(Class<? extends IEvent> clazz) {
        Collection<IEventHandler> handlers = this.bindings.get(clazz);
        if (handlers == null || handlers.isEmpty()) {
            return EMPTYHANDLERS;
        }
        return handlers.toArray(new IEventHandler[handlers.size()]);
    }

    @Override
    public <T extends IEvent> T executeEvent(T event, int i) {
        Collection<IEventHandler> handlers = this.bindings.get(event.getClass());
        if (handlers == null) {
            if (this.debug) {
                CustomFacade.getLog().d("Event " + event.getClass().getSimpleName() + " has no handlers.");
            }
            return event;
        }
        if (this.debug) {
            CustomFacade.getLog().d("Event " + event.getClass().getSimpleName() + " has " + handlers.size() + " handlers.");
        }
        for (IEventHandler handler : handlers) {
            if (i == -1 && handler.getPriority() >= 0 || i == 1 && handler.getPriority() < 0) continue;
            handler.execute(event);
        }
        return event;
    }

    @Override
    public <T extends IEvent> T executeEvent(T event) {
        return this.executeEvent(event, 0);
    }

    @Override
    public void registerListener(EventListener listener) {
        CustomFacade.getLog().v("Register event listener: " + listener);
        if (this.registeredListeners.contains(listener)) {
            CustomFacade.getLog().w("Listener already registred: " + listener);
            return;
        }
        Method[] methods = listener.getClass().getDeclaredMethods();
        this.registeredListeners.add(listener);
        for (Method method : methods) {
            Class<?>[] parameters;
            Event annotation = method.getAnnotation(Event.class);
            if (annotation == null || (parameters = method.getParameterTypes()).length != 1 || !method.getReturnType().equals(Void.TYPE) || !IEvent.class.isAssignableFrom(parameters[0])) continue;
            Class<?> realParam = parameters[0];
            this.registerHandler(realParam, this.createEventHandler(listener, method, annotation));
        }
    }

    @Override
    public void registerHandler(Class<? extends IEvent> realParam, IEventHandler handler) {
        if (!this.bindings.containsKey(realParam)) {
            this.bindings.put(realParam, new TreeSet());
        }
        Collection<IEventHandler> eventHandlersForEvent = this.bindings.get(realParam);
        if (this.debug) {
            CustomFacade.getLog().v("Add handler: " + handler + " for event " + realParam.getSimpleName());
        }
        eventHandlersForEvent.add(handler);
    }

    protected EventHandler createEventHandler(EventListener listener, Method method, Event annotation) {
        return new EventHandler(listener, method, annotation);
    }

    @Override
    public void clearListeners() {
        this.bindings.clear();
        this.registeredListeners.clear();
    }

    @Override
    public void removeListener(EventListener listener) {
        for (Map.Entry<Class<? extends IEvent>, Collection<IEventHandler>> ee : this.bindings.entrySet()) {
            Iterator<IEventHandler> it = ee.getValue().iterator();
            while (it.hasNext()) {
                IEventHandler curr = it.next();
                if (curr.getListener() != listener) continue;
                it.remove();
            }
        }
        this.registeredListeners.remove(listener);
    }

    @Deprecated
    public Map<Class<? extends IEvent>, Collection<IEventHandler>> getBindings() {
        return new HashMap<Class<? extends IEvent>, Collection<IEventHandler>>(this.bindings);
    }

    @Override
    public boolean containsListener(EventListener listener) {
        return this.registeredListeners.contains(listener);
    }

    @Deprecated
    public Set<EventListener> getRegisteredListeners() {
        return new HashSet<EventListener>(this.registeredListeners);
    }

    @Override
    public <T extends IEvent> IEventHandler registerHandler(Class<? extends T> realParam, EventConsumer<T> handler) {
        EventHandlerIface<T> ieh = new EventHandlerIface<T>(handler);
        this.registerHandler(realParam, ieh);
        return ieh;
    }

    @Override
    public <T extends IEvent> IEventHandler registerHandler(Class<? extends T> realParam, EventConsumer<T> handler, int priority) {
        EventHandlerIface<T> ieh = new EventHandlerIface<T>(handler, priority);
        this.registerHandler(realParam, ieh);
        return ieh;
    }

    @Override
    public void removeHandler(IEventHandler listener) {
        for (Map.Entry<Class<? extends IEvent>, Collection<IEventHandler>> ee : this.bindings.entrySet()) {
            Iterator<IEventHandler> it = ee.getValue().iterator();
            while (it.hasNext()) {
                IEventHandler curr = it.next();
                if (curr != listener) continue;
                it.remove();
            }
        }
        this.registeredListeners.remove(listener);
    }
}

