/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android.events;

import android.view.MotionEvent;
import net.zomis.custommap.view.android.IAndroidGameView;
import net.zomis.events.IEvent;

public class AndroidScrollEvent
implements IEvent {
    private final MotionEvent e1;
    private final MotionEvent e2;
    private final float distanceX;
    private final float distanceY;
    private final IAndroidGameView view;

    public AndroidScrollEvent(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY, IAndroidGameView mapView) {
        this.e1 = e1;
        this.e2 = e2;
        this.distanceX = velocityX;
        this.distanceY = velocityY;
        this.view = mapView;
    }

    public MotionEvent getE1() {
        return this.e1;
    }

    public MotionEvent getE2() {
        return this.e2;
    }

    public float getDistanceX() {
        return this.distanceX;
    }

    public float getDistanceY() {
        return this.distanceY;
    }

    public IAndroidGameView getView() {
        return this.view;
    }

    public String toString() {
        return String.format("AndroidScrollEvent %f, %f on view %s", Float.valueOf(this.getDistanceX()), Float.valueOf(this.getDistanceY()), this.getView());
    }

    public float getDistanceLength() {
        return (float)Math.sqrt(this.distanceX * this.distanceX + this.distanceY * this.distanceY);
    }

    public float getAngleRadians() {
        return (float)Math.atan2(this.distanceY, this.distanceX);
    }
}

