/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android;

import android.os.Environment;
import java.io.File;
import java.io.IOException;
import net.zomis.custommap.view.android.LogCatAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.net.SocketAppender;

public class ZomisAndroidLog4j {
    private static final String DEFAULT_LAYOUT = "[%d{ISO8601}] %5p %c{1} [%t] %m%n";

    public static void addSocketAppender(String hostname, int port) {
        Logger root = Logger.getRootLogger();
        AsyncAppender async = new AsyncAppender();
        SocketAppender socket = new SocketAppender(hostname, port);
        async.addAppender((Appender)socket);
        root.addAppender((Appender)async);
    }

    public static void log4jConfigure(Level defaultLevel, String layoutStr) {
        Logger root = Logger.getRootLogger();
        PatternLayout layout = new PatternLayout(layoutStr);
        root.addAppender((Appender)new LogCatAppender((Layout)layout));
        root.setLevel(defaultLevel);
    }

    public static void log4jConfigure(Level defaultLevel) {
        ZomisAndroidLog4j.log4jConfigure(defaultLevel, DEFAULT_LAYOUT);
    }

    public static void addFileAppender(String filename) {
        if (filename != null) {
            try {
                FileAppender file = new FileAppender((Layout)new PatternLayout(DEFAULT_LAYOUT), new File(Environment.getExternalStorageDirectory(), filename).getAbsolutePath(), true);
                Logger.getRootLogger().addAppender((Appender)file);
            }
            catch (IOException e) {
                Logger.getRootLogger().error((Object)("IO Exception for logfile " + e));
            }
        }
    }
}

