/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android;

import android.content.Context;
import android.graphics.Rect;
import android.media.MediaPlayer;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import net.zomis.custommap.CustomFacade;
import net.zomis.custommap.model.GenericMapModel;
import net.zomis.custommap.model.ITileModel;
import net.zomis.custommap.view.android.GestureListener;
import net.zomis.custommap.view.android.IAndroidGameView;
import net.zomis.custommap.view.general.TileInterface;
import net.zomis.custommap.view.general.ViewContainer;
import net.zomis.custommap.view.general.ViewObject;

public abstract class GameView<TM extends ITileModel<?>>
extends ViewContainer<TM>
implements IAndroidGameView,
View.OnTouchListener,
View.OnLongClickListener {
    private ViewGroup boardView;
    protected GenericMapModel<TM> mapModel;
    public int spacing = 0;
    protected int tileSize = 64;
    public int bgColor = -16777216;
    public List<TileInterface<TM>> map;
    protected float scaleFactorMax = 2.1f;
    protected int border = 20;
    private GestureDetector gestureScanner;
    private GestureListener gestureListener;
    private ScaleGestureDetector mScaleDetector;
    private float mScaleFactor = 1.0f;
    boolean inputEnabled = true;
    protected Rect scrollBounds;

    public GenericMapModel<TM> getMapModel() {
        return this.mapModel;
    }

    @Override
    public ViewGroup getLayout() {
        return this.boardView;
    }

    @Override
    public int getTileSizeReal() {
        return this.tileSize;
    }

    @Override
    public int getTileSizeScaled() {
        return (int)((float)this.tileSize * this.mScaleFactor);
    }

    public int getMapWidth() {
        return this.mapModel.getMapWidth();
    }

    public int getMapHeight() {
        return this.mapModel.getMapHeight();
    }

    @Override
    public float getMinScaleFactor() {
        if (this.map == null) {
            return 0.1f;
        }
        int minWH = Math.min(this.boardView.getWidth(), this.boardView.getHeight());
        if (this.map != null) {
            int minTileWH = Math.min(this.getMapHeight(), this.getMapWidth());
            float retur = (float)(((double)(-this.border) * 2.0 + (double)minWH) / (double)(this.getTileSizeReal() * minTileWH));
            return retur;
        }
        CustomFacade.getLog().e("GameView.getMinScaleFactor: returning default (incorrect) value");
        return 0.3f;
    }

    @Override
    public void setAllowInput(boolean allowInput) {
        this.inputEnabled = allowInput;
    }

    @Override
    public boolean isInputEnabled() {
        return this.inputEnabled;
    }

    @Override
    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    public GameView(ViewGroup view, GenericMapModel<TM> model) {
        this.mapModel = model;
        this.boardView = view;
        if (view != null) {
            this.boardView.setOnLongClickListener((View.OnLongClickListener)this);
        }
        this.map = new ArrayList<TileInterface<TM>>();
        this.scrollBounds = new Rect(0, 0, 0, 0);
        if (model != null && model.hasMap()) {
            for (ITileModel tm : model) {
                TileInterface<ITileModel> tv = this.newTileView(this, tm);
                this.map.add(tv);
            }
            this.updateScrollBounds(true);
        }
        this.gestureListener = new GestureListener(this);
        this.gestureScanner = new GestureDetector(view.getContext(), (GestureDetector.OnGestureListener)this.gestureListener, view.getHandler(), true);
        view.setOnTouchListener((View.OnTouchListener)this);
        view.setTag((Object)this);
    }

    @Override
    public void updateScrollBounds(boolean reset) {
        if (this.map != null) {
            TileInterface<TM> tv = this.map.get(0);
            if (tv == null) {
                return;
            }
            if (reset) {
                this.scrollBounds = new Rect(tv.getX(), tv.getY(), tv.getX(), tv.getY());
            }
            this.scrollBounds.union(tv.getX(), tv.getY());
            this.scrollBounds.union(tv.getX() + (int)((float)tv.getWidth() * this.getScaleFactor()), (int)((float)tv.getY() + (float)tv.getHeight() * this.getScaleFactor()));
            tv = this.map.get(this.map.size() - 1);
            this.scrollBounds.union(tv.getX(), tv.getY());
            this.scrollBounds.union(tv.getX() + (int)((float)tv.getWidth() * this.getScaleFactor()), (int)((float)tv.getY() + (float)tv.getHeight() * this.getScaleFactor()));
        } else if (reset) {
            this.scrollBounds = new Rect(0, 0, 0, 0);
        }
    }

    @Override
    public void playSound(int resId) {
        MediaPlayer mp = MediaPlayer.create((Context)this.boardView.getContext(), (int)resId);
        mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                mp.release();
            }
        });
        mp.start();
    }

    public TileInterface<TM> newTileView(GameView<TM> view, TM model) {
        return null;
    }

    @Override
    public boolean onLongClick(View v) {
        CustomFacade.getLog().w("Method not overriden: GridView.onLongClick");
        return false;
    }

    @Override
    public boolean onTouch(View view, MotionEvent event) {
        this.gestureScanner.onTouchEvent(event);
        if (this.mScaleDetector != null) {
            this.mScaleDetector.onTouchEvent(event);
        }
        return false;
    }

    @Override
    public abstract void repaint();

    @Override
    public abstract void resize();

    @Override
    public void addViewToGame(View image, boolean backGround) {
        if (image == null) {
            return;
        }
        if (this.boardView == null) {
            return;
        }
        if (backGround) {
            this.boardView.addView(image, 0);
        } else {
            this.boardView.addView(image);
        }
    }

    @Override
    public void addViewObject(ViewObject object) {
        if (object == null) {
            throw new IllegalArgumentException("View object is null");
        }
        if (!(object.getViewToAdd() instanceof View)) {
            CustomFacade.getLog().e("GameView.addViewObject: View to add is invalid: " + object.toString() + " view to add is " + object.getViewToAdd());
        }
        if (this.boardView == null) {
            throw new NullPointerException("boardView is null");
        }
        if (this.boardView.indexOfChild((View)object.getViewToAdd()) == -1) {
            this.boardView.addView((View)object.getViewToAdd());
        } else {
            CustomFacade.getLog().e("View already exists on GameView: " + object);
        }
    }

    @Override
    public void removeViewObject(ViewObject object) {
        if (object == null) {
            return;
        }
        if (!(object.getViewToAdd() instanceof View)) {
            CustomFacade.getLog().e("GameView.removeViewObject: View to add is invalid: " + object.toString());
        }
        if (this.boardView == null) {
            throw new NullPointerException("boardView is null");
        }
        if (this.boardView != null) {
            if (this.boardView.indexOfChild((View)object.getViewToAdd()) > -1) {
                this.boardView.removeView((View)object.getViewToAdd());
            } else {
                CustomFacade.getLog().e("View does not exists on GameView: " + object);
            }
        }
    }

    @Override
    public void setZoom(float f) {
        this.mScaleFactor = f;
        this.resize();
    }

    @Override
    public Rect getScrollBounds() {
        return this.scrollBounds;
    }
}

