/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.RandomAccess;
import java.util.SortedSet;
import java.util.TreeSet;

public class ZomisList {
    private static final int SHUFFLE_THRESHOLD = 5;
    private static Random random = new Random();

    public static <E> List<E> getAllExtreme(Iterable<E> all, double startValue, GetValueInterface<E> getValue) {
        ArrayList<E> result = new ArrayList<E>();
        double maxValue = startValue;
        for (E e : all) {
            double newValue = getValue.getValue(e);
            if (newValue > maxValue) {
                maxValue = newValue;
                result.clear();
                result.add(e);
                continue;
            }
            if (newValue != maxValue) continue;
            result.add(e);
        }
        return result;
    }

    @Deprecated
    public static <E, F> ArrayList<F> convert(List<E> list, ConversionInterface<E, F> conversion) {
        ArrayList<F> alist = new ArrayList<F>(list.size());
        for (E e : list) {
            alist.add(conversion.convert(e));
        }
        return alist;
    }

    public static <E> E getRandom(List<E> list) {
        return ZomisList.getRandom(list, random);
    }

    public static <E> E getRandom(List<E> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        if (random == null) {
            random = ZomisList.random;
        }
        return list.get(random.nextInt(list.size()));
    }

    public static <E> E getRandom(E[] list) {
        return ZomisList.getRandom(list, random);
    }

    public static <E> E getRandom(E[] list, Random random) {
        if (list.length == 0) {
            return null;
        }
        if (random == null) {
            random = ZomisList.random;
        }
        return list[random.nextInt(list.length)];
    }

    public static <E> void filter(Collection<E> collection, FilterInterface<? super E> filter) {
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            E i = it.next();
            if (filter.shouldKeep(i)) continue;
            it.remove();
        }
    }

    @Deprecated
    public static <E> LinkedList<E> filter2(Collection<E> list, FilterInterface<? super E> filter) {
        LinkedList<E> list2 = new LinkedList<E>(list);
        ZomisList.filter(list2, filter);
        return list2;
    }

    public static <E> List<E> getAll(Iterable<E> collection, FilterInterface<? super E> filter) {
        ArrayList<E> result = new ArrayList<E>();
        for (E e : collection) {
            if (!filter.shouldKeep(e)) continue;
            result.add(e);
        }
        return result;
    }

    @Deprecated
    public static <E> boolean contains(Iterable<E> list, FilterInterface<E> filter) {
        return !ZomisList.getAll(list, filter).isEmpty();
    }

    public static <E> int getSize(Iterable<E> list, FilterInterface<E> filter) {
        return ZomisList.getAll(list, filter).size();
    }

    public static <Element, Key> Map<Key, List<Element>> getMapFor(Iterable<Element> iterable, GetKeyInterface<Element, Key> getKeyInterface) {
        HashMap result = new HashMap();
        for (Element e : iterable) {
            List<Element> arrList;
            Key key = getKeyInterface.getKey(e);
            if (key == null) continue;
            if (!result.containsKey(key)) {
                arrList = new ArrayList<Element>();
                arrList.add(e);
                result.put(key, arrList);
                continue;
            }
            arrList = (List)result.get(key);
            arrList.add(e);
        }
        return result;
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map, final boolean descending) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int res = descending ? ((Comparable)e1.getValue()).compareTo(e2.getValue()) : ((Comparable)e2.getValue()).compareTo(e1.getValue());
                return res != 0 ? -res : 1;
            }
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static <E> E getOrNull(List<E> list, int index) {
        if (list.size() > index) {
            return list.get(index);
        }
        return null;
    }

    public static <E> Comparator<E> listComparator(final List<E> list) {
        return new Comparator<E>(){

            @Override
            public int compare(E arg0, E arg1) {
                return list.indexOf(arg0) - list.indexOf(arg1);
            }
        };
    }

    public static void swap(List<?> list, int i, int j) {
        List<?> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    public static void shuffle(List<?> list, Random rnd) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int i = size; i > 1; --i) {
                ZomisList.swap(list, i - 1, rnd.nextInt(i));
            }
        } else {
            Object[] arr = list.toArray();
            for (int i = size; i > 1; --i) {
                ZomisList.swap(arr, i - 1, rnd.nextInt(i));
            }
            ListIterator<?> it = list.listIterator();
            for (int i = 0; i < arr.length; ++i) {
                it.next();
                it.set(arr[i]);
            }
        }
    }

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static class FilterXOR<E>
    implements FilterInterface<E> {
        private final FilterInterface<E> filterA;
        private final FilterInterface<E> filterB;

        public FilterXOR(FilterInterface<E> filterA, FilterInterface<E> filterB) {
            this.filterA = filterA;
            this.filterB = filterB;
        }

        @Override
        public boolean shouldKeep(E obj) {
            return this.filterA.shouldKeep(obj) ^ this.filterB.shouldKeep(obj);
        }
    }

    public static class FilterAND<E>
    implements FilterInterface<E> {
        private List<FilterInterface<E>> filters = new LinkedList<FilterInterface<E>>();

        public FilterAND<E> addFilter(FilterInterface<E> filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public boolean shouldKeep(E obj) {
            for (FilterInterface<E> filter : this.filters) {
                if (filter.shouldKeep(obj)) continue;
                return false;
            }
            return true;
        }
    }

    public static class FilterOR<E>
    implements FilterInterface<E> {
        private List<FilterInterface<E>> filters = new LinkedList<FilterInterface<E>>();

        public FilterOR<E> addFilter(FilterInterface<E> filter) {
            this.filters.add(filter);
            return this;
        }

        @Override
        public boolean shouldKeep(E obj) {
            for (FilterInterface<E> filter : this.filters) {
                if (!filter.shouldKeep(obj)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface GetKeyInterface<Element, Key> {
        public Key getKey(Element var1);
    }

    @Deprecated
    public static interface ConversionInterface<E, F> {
        public F convert(E var1);
    }

    public static interface GetValueInterface<E> {
        public double getValue(E var1);
    }

    public static interface FilterInterface<E> {
        public boolean shouldKeep(E var1);
    }
}

