/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.iterate;

import java.util.Iterator;
import net.zomis.iterate.IteratorStatus;

public class MapIterator<E>
implements Iterator<E>,
IteratorStatus {
    private int x;
    private int y;
    private final E[][] array;
    private int lastIndexX;
    private int lastIndexY;

    @Override
    public int getLastIndexX() {
        return this.lastIndexX;
    }

    @Override
    public int getLastIndexY() {
        return this.lastIndexY;
    }

    public MapIterator(E[][] array) {
        this.array = array;
        this.x = 0;
        this.y = 0;
    }

    public void reset() {
        this.x = 0;
        this.y = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.array == null) {
            return false;
        }
        if (this.y >= this.array[this.x].length) {
            return false;
        }
        return this.x < this.array.length;
    }

    @Override
    public E next() {
        if (this.array == null) {
            throw new NullPointerException("Array is null");
        }
        if (!this.hasNext()) {
            throw new IllegalStateException("Doesn't have next");
        }
        this.lastIndexX = this.x;
        this.lastIndexY = this.y;
        E ev = this.array[this.x][this.y];
        ++this.x;
        if (this.x >= this.array.length) {
            this.x = 0;
            ++this.y;
        }
        return ev;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNextLineBreak() {
        return this.getLastIndexX() == this.array.length - 1;
    }
}

