/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import net.zomis.custommap.CustomFacade;
import net.zomis.custommap.model.ITileModel;
import net.zomis.custommap.view.general.TileInterface;
import net.zomis.custommap.view.swing.ISwingGameView;
import net.zomis.custommap.view.swing.MapPaintable;
import net.zomis.custommap.view.swing.events.CustommapSwingTileClick;

public abstract class TileView<TM extends ITileModel<?>>
extends MapPaintable
implements TileInterface<TM> {
    protected TM model;

    public TileView(ISwingGameView mapView, TM model) {
        super(mapView);
        this.model = model;
        this.x = this.model.getX() * mapView.getTileSizeReal();
        this.y = this.model.getY() * mapView.getTileSizeReal();
        this.updatePosition();
        this.image.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                CustomFacade.getLog().i("Execute click event");
                CustomFacade.getGlobalEvents().executeEvent(new CustommapSwingTileClick(TileView.this, event));
            }
        });
    }

    @Override
    public TM getModel() {
        return this.model;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getXPos() {
        return this.model.getX();
    }

    @Override
    public int getYPos() {
        return this.model.getY();
    }

    @Override
    public abstract void update();
}

