/*
 * Decompiled with CFR 0.152.
 */
package net.zomis.custommap.view.android.drag;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.IBinder;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

public class DragView
extends View {
    private static final int DRAG_SCALE = 0;
    private Bitmap mBitmap;
    private Paint mPaint = new Paint();
    private int mRegistrationX;
    private int mRegistrationY;
    private float mAnimationScale = 0.9f;
    private WindowManager.LayoutParams mLayoutParams;
    private WindowManager mWindowManager;
    private Paint p2 = new Paint();

    public DragView(Context context, Bitmap bitmap, int registrationX, int registrationY, int left, int top, int width, int height) {
        super(context);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(-2013209327);
        this.mPaint.setAlpha(80);
        this.p2.setAlpha(100);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        Matrix scale = new Matrix();
        float scaleFactor = width;
        scaleFactor = (scaleFactor + 0.0f) / scaleFactor;
        scale.setScale(scaleFactor, scaleFactor);
        this.mBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)left, (int)top, (int)width, (int)height, (Matrix)scale, (boolean)true);
        this.mRegistrationX = registrationX + 0;
        this.mRegistrationY = registrationY + 0;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mBitmap.getWidth(), this.mBitmap.getHeight());
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint);
        float scale = this.mAnimationScale;
        if (scale < 0.999f) {
            float height = this.mBitmap.getHeight();
            float width = this.mBitmap.getWidth();
            float offset1 = (width - width * scale) / 2.0f;
            float offset2 = (height - height * scale) / 2.0f;
            canvas.translate(offset1, offset2);
            canvas.scale(scale, scale);
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.p2);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBitmap.recycle();
    }

    public void setPaint(Paint paint) {
        this.mPaint = paint;
        this.invalidate();
    }

    public void setScale(float scale) {
        this.mAnimationScale = scale > 1.0f ? 1.0f : scale;
        this.invalidate();
    }

    public void show(IBinder windowToken, int touchX, int touchY) {
        int pixelFormat = -3;
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-2, -2, touchX - this.mRegistrationX, touchY - this.mRegistrationY, 1002, 768, pixelFormat);
        lp.gravity = 51;
        lp.token = windowToken;
        lp.setTitle((CharSequence)"DragView");
        this.mLayoutParams = lp;
        this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)lp);
    }

    public void move(int touchX, int touchY) {
        WindowManager.LayoutParams lp = this.mLayoutParams;
        lp.x = touchX - this.mRegistrationX;
        lp.y = touchY - this.mRegistrationY;
        this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)lp);
    }

    public void remove() {
        this.mWindowManager.removeView((View)this);
    }
}

